/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.libVulpes.block.BlockMeta;

public class MapGenCraterHuge
extends MapGenBase {
    int chancePerChunk;

    public MapGenCraterHuge(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
        this.field_75040_a = 52;
    }

    private static boolean isCraterIgnoredBlock(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock || block == Blocks.field_150350_a || block == Blocks.field_150432_aD;
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        int i = this.field_75040_a;
        this.field_75039_c = worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        for (int l = x - i; l <= x + i; ++l) {
            for (int i1 = z - i; i1 <= z + i; ++i1) {
                long j1 = (long)l * j;
                long k1 = (long)i1 * k;
                this.field_75038_b.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
                this.func_180701_a(worldIn, l, i1, x, z, primer);
            }
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int p_180701_4_, int p_180701_5_, ChunkPrimer chunkPrimerIn) {
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension());
        List<IBlockState> ores = props.craterOres.stream().filter(OreDictionary::doesOreNameExist).map(s -> (ItemStack)OreDictionary.getOres((String)s).get(0)).map(itemStack -> new BlockMeta(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77952_i()).getBlockState()).collect(Collectors.toList());
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk && this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk && this.shouldCraterSpawn(DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()), world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)))) {
            int y;
            int z;
            int x;
            int[] sinCoefficients = new int[]{this.field_75038_b.nextInt(10) + 1, this.field_75038_b.nextInt(10) + 1, this.field_75038_b.nextInt(10) + 1, this.field_75038_b.nextInt(10) + 1, this.field_75038_b.nextInt(10) + 1};
            int baseRadius = this.getBaseRadius(this.field_75038_b.nextInt(400));
            int numBulges = this.field_75038_b.nextInt(5) + 1;
            boolean spire = this.field_75038_b.nextInt(4) == 0;
            int xCoord = -chunkX + p_180701_4_;
            int zCoord = -chunkZ + p_180701_5_;
            IBlockState fillBlock = Blocks.field_150350_a.func_176223_P();
            int fluidMaxY = 0;
            for (x = 15; x >= 0; --x) {
                block1: for (z = 15; z >= 0; --z) {
                    for (y = 254; y >= 0; --y) {
                        if (chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() instanceof BlockLiquid || chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() instanceof IFluidBlock) {
                            if (y <= fluidMaxY) continue;
                            fillBlock = chunkPrimerIn.func_177856_a(x, y, z);
                            fluidMaxY = y;
                            continue;
                        }
                        if (chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150350_a) continue block1;
                    }
                }
            }
            for (x = 15; x >= 0; --x) {
                block4: for (z = 15; z >= 0; --z) {
                    for (y = 254; y >= 0; --y) {
                        int dist;
                        if (y <= fluidMaxY && fillBlock.func_177230_c() != Blocks.field_150350_a && chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150350_a) {
                            chunkPrimerIn.func_177855_a(x, y, z, fillBlock);
                        }
                        if (MapGenCraterHuge.isCraterIgnoredBlock(chunkPrimerIn.func_177856_a(x, y, z).func_177230_c())) continue;
                        int radius = this.getRadius(baseRadius, xCoord * 16 + x, zCoord * 16 + z, numBulges, sinCoefficients);
                        int distancesSquared = (xCoord * 16 + x) * (xCoord * 16 + x) + (zCoord * 16 + z) * (zCoord * 16 + z);
                        int blockRadius = (int)Math.sqrt(distancesSquared);
                        int inversePartialSquareRadius = (int)((double)(radius * radius - distancesSquared) / ((double)baseRadius * (baseRadius > 256 ? 4.0 : (baseRadius > 128 ? 3.0 : 2.25))));
                        int inverseRadius = radius - blockRadius;
                        for (int dist2 = 0; dist2 < inversePartialSquareRadius; ++dist2) {
                            if (y - dist2 <= 2) continue;
                            chunkPrimerIn.func_177855_a(x, y - Math.min(27, dist2), z, y - dist2 <= fluidMaxY ? fillBlock : Blocks.field_150350_a.func_176223_P());
                        }
                        double ridgeSize = Math.max(1.0, (double)(12 * radius) / 64.0);
                        if (inverseRadius <= radius / 4 && inverseRadius > -3 * radius) {
                            dist = -1;
                            while ((double)dist < 9.0 * ridgeSize * ((double)(1 - inverseRadius) / (0.8 * (double)radius + (double)((inverseRadius - 1) * (inverseRadius - 1)))) - 1.06) {
                                if (y + dist < 255 && (double)inverseRadius > -0.75 * (double)radius) {
                                    chunkPrimerIn.func_177855_a(x, y + dist, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                } else if (y + dist < 255 && (double)inverseRadius >= -0.875 * (double)radius && this.field_75038_b.nextInt(inverseRadius + (int)((double)radius * 0.875) + 1) != 0) {
                                    chunkPrimerIn.func_177855_a(x, y + dist, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                } else if (y + dist < 255 && (double)inverseRadius < -0.875 * (double)radius && this.field_75038_b.nextInt(Math.abs(inverseRadius + (int)((double)radius * 0.875)) + 1) == 0) {
                                    chunkPrimerIn.func_177855_a(x, y + dist, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                }
                                if (this.field_75038_b.nextInt(Math.abs(inverseRadius) + 1) == 0) {
                                    if ((double)inverseRadius < -0.375 * (double)radius && (double)inverseRadius > -1.5 * (double)radius) {
                                        chunkPrimerIn.func_177855_a(x, y + dist + 1, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                    } else if ((double)inverseRadius < -1.5 * (double)radius) {
                                        chunkPrimerIn.func_177855_a(x, y + dist + 1 + this.field_75038_b.nextInt(2), z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                    }
                                }
                                ++dist;
                            }
                        }
                        if (inversePartialSquareRadius >= 0) {
                            chunkPrimerIn.func_177855_a(x, y - Math.min(28, inversePartialSquareRadius), z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                            chunkPrimerIn.func_177855_a(x, y - 1 - Math.min(28, inversePartialSquareRadius), z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                        }
                        if (!((double)blockRadius < 0.25 * (double)radius) || !spire) continue block4;
                        dist = 0;
                        while ((double)dist < Math.pow(Math.abs(-((double)radius / 16.0) + (double)blockRadius / 4.0), 1.25)) {
                            chunkPrimerIn.func_177855_a(x, y + Math.min(dist, 16) - 27, z, this.getBlockToPlaceRich(world, chunkX, chunkZ, ores));
                            ++dist;
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    private IBlockState getBlockToPlace(World world, int chunkX, int chunkZ, List<IBlockState> ores) {
        if (this.field_75038_b.nextInt(24) == 0 && !ores.isEmpty()) {
            return ores.get(this.field_75038_b.nextInt(ores.size()));
        }
        return world.func_180494_b((BlockPos)new BlockPos((int)(chunkX * 16), (int)0, (int)(chunkZ * 16))).field_76752_A;
    }

    private IBlockState getBlockToPlaceRich(World world, int chunkX, int chunkZ, List<IBlockState> ores) {
        if (this.field_75038_b.nextInt(4) == 0 && !ores.isEmpty()) {
            return ores.get(this.field_75038_b.nextInt(ores.size()));
        }
        return world.func_180494_b((BlockPos)new BlockPos((int)(chunkX * 16), (int)0, (int)(chunkZ * 16))).field_76752_A;
    }

    private boolean shouldCraterSpawn(DimensionProperties properties, Biome biome) {
        if (properties.getCraterBiomeWeights().isEmpty()) {
            return true;
        }
        for (BiomeManager.BiomeEntry biomeEntry : properties.getCraterBiomeWeights()) {
            if (!biomeEntry.biome.equals(biome) || biomeEntry.field_76292_a <= this.field_75038_b.nextInt(99)) continue;
            return true;
        }
        return false;
    }

    private int getBaseRadius(int random) {
        int radius = 84;
        if (random < 200) {
            radius += this.field_75038_b.nextInt(75);
        } else if (random < 325) {
            radius += 24 + this.field_75038_b.nextInt(75);
        } else if (random < 375) {
            radius += 40 + this.field_75038_b.nextInt(75);
        } else if (random < 400) {
            radius += 56 + this.field_75038_b.nextInt(75);
        }
        return radius;
    }

    private int getRadius(int base, int x, int z, int bumps, int[] random) {
        double radians = Math.atan2(x, z);
        int extras = 0;
        for (int i = 2; i < Math.min(5, bumps) + 2; ++i) {
            extras = (int)((double)extras + (double)(random[i - 2] * base) * Math.sin((double)i * radians) * 0.0075);
        }
        return base + extras;
    }
}

