/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.mekanismtweaks;

import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;

public class Utils {
    public static double time(IUpgradeTile tile) {
        return Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (double)tile.getComponent().getUpgrades(Upgrade.SPEED) / -8.0);
    }

    public static double electricity(IUpgradeTile tile) {
        int speed = tile.getComponent().getUpgrades(Upgrade.SPEED);
        int energy = tile.getComponent().getUpgrades(Upgrade.ENERGY);
        return Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (double)(2 * speed - Math.min(energy, Math.max(8, speed))) / 8.0);
    }

    public static double capacity(IUpgradeTile tile) {
        return Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (double)tile.getComponent().getUpgrades(Upgrade.ENERGY) / 8.0);
    }

    public static String exponential(double d) {
        int significant = 4;
        int exp = (int)Math.floor(Math.log10(d));
        d *= Math.pow(10.0, -exp);
        d = (double)((int)Math.round(d * Math.pow(10.0, significant - 1))) / Math.pow(10.0, significant - 1);
        double dt = (double)((int)Math.round(d * Math.pow(10.0, significant - 1))) / Math.pow(10.0, significant - 1 - exp);
        return Math.abs(exp) <= significant - 1 ? String.valueOf(dt) : d + "E" + exp;
    }

    public static int clampToInt(double d) {
        if (d < 2.147483647E9) {
            return (int)d;
        }
        return Integer.MAX_VALUE;
    }
}

