/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.mekanismtweaks.mixin;

import dev.felnull.mekanismtweaks.Utils;
import java.util.ArrayList;
import java.util.List;
import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Upgrade.class}, remap=false)
public abstract class MixinUpgrade {
    @Shadow
    private int maxStack;

    @Shadow
    public abstract boolean canMultiply();

    @Overwrite
    public int getMax() {
        Upgrade upgrade = (Upgrade)this;
        return upgrade == Upgrade.SPEED || upgrade == Upgrade.ENERGY ? 64 : this.maxStack;
    }

    @Overwrite
    public List<String> getExpScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.canMultiply()) {
            ret.add(LangUtils.localize((String)"gui.upgrades.effect") + ": " + Utils.time(tile) + "x");
        }
        return ret;
    }

    @Overwrite
    public List<String> getMultScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        Upgrade upgrade = (Upgrade)this;
        if (this.canMultiply()) {
            double effect = upgrade == Upgrade.ENERGY ? Utils.capacity(tile) : (upgrade == Upgrade.SPEED ? Utils.time(tile) : Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (float)tile.getComponent().getUpgrades(upgrade) / (float)this.getMax()));
            ret.add(LangUtils.localize((String)"gui.upgrades.effect") + ": " + Utils.exponential(effect) + "x");
        }
        return ret;
    }
}

