/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import icbm.classic.cc.builder.PeripheralBuilder;
import icbm.classic.cc.methods.BaseLauncherMethods;
import icbm.classic.cc.methods.CommonMethods;
import icbm.classic.cc.methods.ConnectorMethods;
import icbm.classic.cc.methods.CruiseLauncherMethods;
import icbm.classic.cc.methods.EnergyMethods;
import icbm.classic.cc.methods.LauncherMethods;
import icbm.classic.cc.methods.RadarMethods;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PeripheralProvider
implements IPeripheralProvider {
    public static final PeripheralBuilder<TileEntity> machine = new PeripheralBuilder("icbmclassic:machine").withMethod("getEnergyData", EnergyMethods::getEnergyData).withMethod("getEnergy", EnergyMethods::getEnergy).withMethod("getEnergyLimit", EnergyMethods::getEnergyLimit).withMethod("getMachineInfo", CommonMethods::getMachineInfo);
    public static final PeripheralBuilder<TileRadarStation> radarBuilder = machine.copy("icbmclassic:radar.station", TileRadarStation.class).withMethod("getDetectionRange", RadarMethods::getDetectionRange).withMethod("setDetectionRange", RadarMethods::setDetectionRange).withMethod("getTriggerRange", RadarMethods::getTriggerRange).withMethod("setTriggerRange", RadarMethods::setTriggerRange).withMethod("getContacts", RadarMethods::getContacts);
    public static final PeripheralBuilder<TileEntity> launcher = machine.copy("icbmclassic:launcher", TileEntity.class).withMethod("getMissiles", LauncherMethods::getMissiles).withMethod("launch", LauncherMethods::launchMissile).withMethod("getInaccuracy", LauncherMethods::getInaccuracy).withMethod("getStatus", LauncherMethods::getStatus).withMethod("preCheckLaunch", LauncherMethods::preLaunchCheck);
    public static final PeripheralBuilder<TileCruiseLauncher> cruiseLauncher = launcher.copy("icbmclassic:launcher.cruise", TileCruiseLauncher.class).withMethod("getTarget", CruiseLauncherMethods::getTarget).withMethod("setTarget", CruiseLauncherMethods::setTarget).withMethod("isAimed", CruiseLauncherMethods::isAimed).withMethod("getAimCurrent", CruiseLauncherMethods::getCurrentAim).withMethod("getAimTarget", CruiseLauncherMethods::getCurrentAim);
    public static final PeripheralBuilder<TileLauncherBase> baseLauncher = launcher.copy("icbmclassic:launcher.pad", TileLauncherBase.class).withMethod("getLockHeight", BaseLauncherMethods::getLockHeight).withMethod("setLockHeight", BaseLauncherMethods::setLockHeight).withMethod("getFiringDelay", BaseLauncherMethods::getFiringDelay).withMethod("setFiringDelay", BaseLauncherMethods::setFiringDelay);
    public static final PeripheralBuilder<TileEntity> connectors = machine.copy("icbmclassic:launcher.connector", TileEntity.class).withMethod("getLaunchers", ConnectorMethods::getLaunchers).withMethod("launch", ConnectorMethods::launch);

    public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing connectedSide = side.func_176734_d();
        if (tile instanceof TileRadarStation) {
            return radarBuilder.build((TileRadarStation)tile, connectedSide);
        }
        if (tile instanceof TileLauncherBase) {
            return baseLauncher.build((TileLauncherBase)tile, connectedSide);
        }
        if (tile instanceof TileCruiseLauncher) {
            return cruiseLauncher.build((TileCruiseLauncher)tile, connectedSide);
        }
        if (tile instanceof ILauncherComponent) {
            return connectors.build(tile, connectedSide);
        }
        return null;
    }
}

