/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.builder;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import icbm.classic.cc.builder.PeripheralMethod;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Peripheral<T>
implements IPeripheral,
ILuaObject {
    private final String type;
    private final String[] methodNames;
    private final List<PeripheralMethod<T>> methods;
    private final T tile;
    private final BlockPos computerPos;
    private final EnumFacing accessedSide;

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
        if (method >= 0 && method < this.methods.size()) {
            return this.methods.get(method).invoke(this, computer, context, args);
        }
        throw new LuaException("Unknown method");
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral instanceof Peripheral && Objects.equals(((Peripheral)iPeripheral).type, this.type) && ((Peripheral)iPeripheral).tile == this.tile;
    }

    @Nullable
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
        if (method >= 0 && method < this.methods.size()) {
            return this.methods.get(method).invoke(this, null, context, args);
        }
        throw new LuaException("Unknown method");
    }

    public Peripheral(String type, String[] methodNames, List<PeripheralMethod<T>> methods, T tile, BlockPos computerPos, EnumFacing accessedSide) {
        this.type = type;
        this.methodNames = methodNames;
        this.methods = methods;
        this.tile = tile;
        this.computerPos = computerPos;
        this.accessedSide = accessedSide;
    }

    public String getType() {
        return this.type;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public T getTile() {
        return this.tile;
    }

    public BlockPos getComputerPos() {
        return this.computerPos;
    }

    public EnumFacing getAccessedSide() {
        return this.accessedSide;
    }
}

