/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.builder;

import icbm.classic.cc.builder.MethodFuncArgs;
import icbm.classic.cc.builder.MethodFuncContext;
import icbm.classic.cc.builder.MethodFuncGet;
import icbm.classic.cc.builder.Peripheral;
import icbm.classic.cc.builder.PeripheralMethod;
import icbm.classic.cc.builder.PeripheralMethodFunc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PeripheralBuilder<T extends TileEntity> {
    private final String type;
    private final List<PeripheralMethod<T>> methods = new ArrayList<PeripheralMethod<T>>();

    public PeripheralBuilder(String type) {
        this.type = type;
    }

    public PeripheralBuilder<T> withMethod(PeripheralMethod<T> method) {
        this.methods.add(method);
        return this;
    }

    private PeripheralBuilder<T> withMethods(List<PeripheralMethod<T>> methodsToAdd) {
        this.methods.addAll(methodsToAdd);
        return this;
    }

    public PeripheralBuilder<T> withMethod(String type, MethodFuncContext<T> method) {
        this.methods.add(new PeripheralMethodFunc<T>(type, method));
        return this;
    }

    public PeripheralBuilder<T> withMethod(String type, MethodFuncArgs<T> method) {
        this.methods.add(new PeripheralMethodFunc(type, (peripheral, computer, context, args) -> method.apply(peripheral, args)));
        return this;
    }

    public PeripheralBuilder<T> withMethod(String type, MethodFuncGet<T> method) {
        this.methods.add(new PeripheralMethodFunc(type, (peripheral, computer, context, args) -> method.apply(peripheral)));
        return this;
    }

    public String[] gatherMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int index = 0; index < this.methods.size(); ++index) {
            names[index] = this.methods.get(index).getName();
        }
        return names;
    }

    public Peripheral<T> build(T tile, EnumFacing side) {
        return new Peripheral<T>(this.type, this.gatherMethodNames(), this.methods, tile, tile.func_174877_v().func_177972_a(side), side);
    }

    public Peripheral<T> build(T tile, BlockPos computerPos) {
        return new Peripheral<T>(this.type, this.gatherMethodNames(), this.methods, tile, computerPos, null);
    }

    public <X extends T> PeripheralBuilder<X> copy(String type, Class<X> clazz) {
        PeripheralBuilder newCopy = new PeripheralBuilder(type);
        this.methods.forEach(m -> newCopy.withMethod((PeripheralMethod)m));
        return newCopy;
    }
}

