/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.methods;

import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.LuaException;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.cc.PeripheralProvider;
import icbm.classic.cc.builder.Peripheral;
import icbm.classic.cc.methods.LauncherMethods;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherEntry;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;

public class ConnectorMethods {
    public static <T extends TileEntity> Object[] getLaunchers(@Nonnull Peripheral<T> peripheral, @Nonnull Object[] objects) throws LuaException {
        TileEntity tile = (TileEntity)peripheral.getTile();
        if (tile instanceof ILauncherComponent) {
            if (((ILauncherComponent)tile).getNetworkNode().getNetwork() == null) {
                return new Object[]{null, null, "No Network"};
            }
            List launchers = ((ILauncherComponent)tile).getNetworkNode().getNetwork().getLaunchers();
            HashMap<Integer, HashMap<Object, Object>> table = new HashMap<Integer, HashMap<Object, Object>>();
            for (int i = 0; i < launchers.size(); ++i) {
                LauncherEntry launcher = (LauncherEntry)launchers.get(i);
                HashMap<Object, Object> entry = new HashMap<Object, Object>();
                ConnectorMethods.loadLauncherData(peripheral, launcher, entry);
                table.put(i, entry);
            }
            return new Object[]{table, launchers.size(), null};
        }
        throw new LuaException("tile doesn't support launcher component");
    }

    private static <T extends TileEntity> void loadLauncherData(@Nonnull Peripheral<T> peripheral, LauncherEntry launcher, Map<Object, Object> entry) {
        entry.put("GROUP_ID", launcher.getLauncher().getLauncherGroup());
        entry.put("GROUP_INDEX", launcher.getLauncher().getLaunchIndex());
        entry.put("X", launcher.getHost().func_174877_v().func_177958_n());
        entry.put("Y", launcher.getHost().func_174877_v().func_177956_o());
        entry.put("Z", launcher.getHost().func_174877_v().func_177952_p());
        entry.put("LAUNCHER", PeripheralProvider.launcher.build(launcher.getHost(), peripheral.getComputerPos()));
    }

    public static <T extends TileEntity> Object[] launch(@Nonnull Peripheral<T> peripheral, @Nonnull Object[] args) throws LuaException {
        TileEntity tile = (TileEntity)peripheral.getTile();
        if (tile instanceof ILauncherComponent) {
            LauncherNode node = ((ILauncherComponent)tile).getNetworkNode();
            if (node.getNetwork() == null) {
                return new Object[]{null, null, new Object[]{false, false, "icbmclassic:error.network.none", "Firing Safety; No network"}};
            }
            Map table = ArgumentHelper.getTable((Object[])args, (int)0);
            boolean simulate = ArgumentHelper.getBoolean((Object[])args, (int)1);
            IMissileTarget targetData = LauncherMethods.getTarget(table);
            Integer firingGroup = Optional.ofNullable(table.get("group")).map(s -> (int)((Integer)s)).orElse(null);
            List launchers = node.getNetwork().getLaunchers().stream().filter(entry -> firingGroup == null || firingGroup.intValue() == entry.getLauncher().getLauncherGroup()).collect(Collectors.toList());
            int count = launchers.size();
            if (count == 0) {
                return new Object[]{null, null, new Object[]{false, false, "icbmclassic:error.group.empty", "Firing Safety; No missiles in group"}};
            }
            IActionCause cause = LauncherMethods.createLaunchCause(peripheral);
            TreeMap<Integer, TreeMap<Object, Object>> results = new TreeMap<Integer, TreeMap<Object, Object>>();
            for (int i = 0; i < count; ++i) {
                LauncherEntry launcher = (LauncherEntry)launchers.get(i);
                IActionStatus status = launcher.getLauncher().launch(targetData, cause, simulate);
                TreeMap<Object, Object> resultEntry = new TreeMap<Object, Object>();
                resultEntry.put("RESULT", LauncherMethods.convertStatus(status));
                ConnectorMethods.loadLauncherData(peripheral, launcher, resultEntry);
                results.put(i, resultEntry);
            }
            return new Object[]{results, count, null};
        }
        throw new LuaException("tile doesn't support launcher component");
    }
}

