/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.methods;

import dan200.computercraft.api.lua.LuaException;
import icbm.classic.cc.builder.Peripheral;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class EnergyMethods {
    public static <T extends TileEntity> Object[] getEnergy(Peripheral<T> peripheral) throws LuaException {
        return new Object[]{EnergyMethods.getStorage(peripheral).getEnergyStored()};
    }

    public static <T extends TileEntity> Object[] getEnergyLimit(Peripheral<T> peripheral) throws LuaException {
        return new Object[]{EnergyMethods.getStorage(peripheral).getMaxEnergyStored()};
    }

    public static <T extends TileEntity> Object[] getEnergyData(Peripheral<T> peripheral) throws LuaException {
        return new Object[]{EnergyMethods.getStorage(peripheral).getEnergyStored(), EnergyMethods.getStorage(peripheral).getMaxEnergyStored()};
    }

    private static <T extends TileEntity> IEnergyStorage getStorage(Peripheral<T> peripheral) throws LuaException {
        if (!((TileEntity)peripheral.getTile()).hasCapability(CapabilityEnergy.ENERGY, peripheral.getAccessedSide())) {
            throw new LuaException("Error: Tile doesn't support IEnergyStorage capability");
        }
        IEnergyStorage storage = (IEnergyStorage)((TileEntity)peripheral.getTile()).getCapability(CapabilityEnergy.ENERGY, peripheral.getAccessedSide());
        if (storage == null) {
            throw new LuaException("Error: Tile didn't provide IEnergyStorage capability");
        }
        return storage;
    }
}

