/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.methods;

import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.cc.builder.Peripheral;
import icbm.classic.cc.methods.MethodHelpers;
import icbm.classic.content.missile.logic.source.cause.CausedByBlock;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public final class LauncherMethods {
    public static <T extends TileEntity> Object[] getMissiles(Peripheral<T> peripheral) {
        IMissileHolder holder;
        if (((TileEntity)peripheral.getTile()).hasCapability(ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY, peripheral.getAccessedSide()) && (holder = (IMissileHolder)((TileEntity)peripheral.getTile()).getCapability(ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY, peripheral.getAccessedSide())) != null) {
            ICapabilityMissileStack stackCap;
            ItemStack missileStack = holder.getMissileStack();
            if (missileStack.func_190926_b()) {
                return new Object[]{"empty"};
            }
            if (missileStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, peripheral.getAccessedSide()) && (stackCap = (ICapabilityMissileStack)missileStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, peripheral.getAccessedSide())) != null) {
                return new Object[]{stackCap.getMissileId()};
            }
            return new Object[]{missileStack.toString()};
        }
        return new Object[]{"not supported"};
    }

    public static <T extends TileEntity> Object[] getStatus(Peripheral<T> peripheral) throws LuaException {
        IMissileLauncher launcher = LauncherMethods.getLauncher(peripheral);
        return LauncherMethods.convertStatus(launcher.getStatus());
    }

    public static <T extends TileEntity> Object[] launchMissile(@Nonnull Peripheral<T> peripheral, @Nonnull IComputerAccess computer, @Nonnull ILuaContext context, @Nonnull Object[] args) throws LuaException, InterruptedException {
        Map table = ArgumentHelper.getTable((Object[])args, (int)0);
        boolean simulate = ArgumentHelper.getBoolean((Object[])args, (int)1);
        IMissileTarget targetData = LauncherMethods.getTarget(table);
        IMissileLauncher launcher = LauncherMethods.getLauncher(peripheral);
        return context.executeMainThreadTask(() -> {
            IActionCause cause = LauncherMethods.createLaunchCause(peripheral);
            IActionStatus status = launcher.launch(targetData, cause, simulate);
            return LauncherMethods.convertStatus(status);
        });
    }

    public static <T extends TileEntity> IMissileLauncher getLauncher(@Nonnull Peripheral<T> peripheral) throws LuaException {
        if (!((TileEntity)peripheral.getTile()).hasCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, peripheral.getAccessedSide())) {
            throw new LuaException("tile is missing launcher capability support");
        }
        IMissileLauncher launcher = (IMissileLauncher)((TileEntity)peripheral.getTile()).getCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, peripheral.getAccessedSide());
        if (launcher == null) {
            throw new LuaException("tile is missing launcher capability");
        }
        return launcher;
    }

    public static <T extends TileEntity> Object[] getInaccuracy(@Nonnull Peripheral<T> peripheral, @Nonnull Object[] objects) throws LuaException {
        Map table = ArgumentHelper.getTable((Object[])objects, (int)0);
        IMissileTarget targetData = LauncherMethods.getTarget(table);
        int launcherCount = ArgumentHelper.optInt((Object[])objects, (int)1, (int)1);
        IMissileLauncher launcher = LauncherMethods.getLauncher(peripheral);
        return new Object[]{Float.valueOf(launcher.getInaccuracy(targetData.getPosition(), launcherCount))};
    }

    public static <T extends TileEntity> Object[] preLaunchCheck(@Nonnull Peripheral<T> peripheral, @Nonnull Object[] objects) throws LuaException {
        Map table = ArgumentHelper.getTable((Object[])objects, (int)0);
        IMissileTarget targetData = LauncherMethods.getTarget(table);
        IActionCause cause = LauncherMethods.createLaunchCause(peripheral);
        IMissileLauncher launcher = LauncherMethods.getLauncher(peripheral);
        return LauncherMethods.convertStatus(launcher.preCheckLaunch(targetData, cause));
    }

    public static <T extends TileEntity> IActionCause createLaunchCause(@Nonnull Peripheral<T> peripheral) {
        BlockPos sourceBlock = peripheral.getComputerPos();
        return new CausedByBlock(((TileEntity)peripheral.getTile()).func_145831_w(), sourceBlock, ((TileEntity)peripheral.getTile()).func_145831_w().func_180495_p(sourceBlock));
    }

    public static Object[] convertStatus(IActionStatus status) {
        return new Object[]{status.getTypeTags().contains(ActionStatusTypes.ERROR), status.getTypeTags().contains(ActionStatusTypes.BLOCKING), status.getRegistryKey().toString(), status.message().func_150254_d()};
    }

    public static IMissileTarget getTarget(Map<?, ?> table) throws LuaException {
        double x = MethodHelpers.getNumeric(table, "x", "Error: failed to get x value...");
        double y = MethodHelpers.getNumeric(table, "y", "Error: failed to get y value...");
        double z = MethodHelpers.getNumeric(table, "z", "Error: failed to get z value...");
        int delay = (int)Math.floor(MethodHelpers.getNumeric(table, "delay", "Error: failed to get delay value...", 0.0));
        return new BasicTargetData(x, y, z).withFiringDelay(delay);
    }
}

