/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.cc.methods;

import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.cc.builder.Peripheral;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;

public final class RadarMethods {
    public static <T extends TileRadarStation> Object[] getDetectionRange(Peripheral<T> peripheral) throws LuaException {
        return new Object[]{((TileRadarStation)peripheral.getTile()).getDetectionRange()};
    }

    public static <T extends TileRadarStation> Object[] setDetectionRange(@Nonnull Peripheral<T> peripheral, @Nonnull IComputerAccess computer, @Nonnull ILuaContext context, @Nonnull Object[] args) throws LuaException, InterruptedException {
        int range = ArgumentHelper.getInt((Object[])args, (int)0);
        return context.executeMainThreadTask(() -> {
            ((TileRadarStation)peripheral.getTile()).setDetectionRange(range);
            return null;
        });
    }

    public static <T extends TileRadarStation> Object[] getTriggerRange(Peripheral<T> peripheral) throws LuaException {
        return new Object[]{((TileRadarStation)peripheral.getTile()).getTriggerRange()};
    }

    public static <T extends TileRadarStation> Object[] setTriggerRange(@Nonnull Peripheral<T> peripheral, @Nonnull IComputerAccess computer, @Nonnull ILuaContext context, @Nonnull Object[] args) throws LuaException, InterruptedException {
        int range = ArgumentHelper.getInt((Object[])args, (int)0);
        return context.executeMainThreadTask(() -> {
            ((TileRadarStation)peripheral.getTile()).setTriggerRange(range);
            return null;
        });
    }

    public static <T extends TileRadarStation> Object[] getContacts(@Nonnull Peripheral<T> peripheral, @Nonnull IComputerAccess computer, @Nonnull ILuaContext context, @Nonnull Object[] args) throws LuaException, InterruptedException {
        TileRadarStation tile = (TileRadarStation)peripheral.getTile();
        boolean triggerArea = ArgumentHelper.getBoolean((Object[])args, (int)0);
        int limit = ArgumentHelper.optInt((Object[])args, (int)1, (int)10);
        if (limit <= 0) {
            throw new LuaException("entry limit must be greater than 0");
        }
        return context.executeMainThreadTask(() -> {
            List entities = triggerArea ? tile.getIncomingThreats().stream().map(IMissile::getMissileEntity).limit(limit).collect(Collectors.toList()) : tile.getDetectedThreats();
            int count = triggerArea ? tile.getIncomingThreats().size() : tile.getDetectedThreats().size();
            TreeMap entityTable = new TreeMap(Integer::compareTo);
            for (int i = 0; i < entities.size() && i < limit; ++i) {
                Entity entity = (Entity)entities.get(i);
                TreeMap<String, Number> entryTable = new TreeMap<String, Number>();
                entryTable.put("SIZE_H", Float.valueOf(entity.field_70131_O));
                entryTable.put("SIZE_W", Float.valueOf(entity.field_70130_N));
                entryTable.put("X", entity.field_70165_t);
                entryTable.put("Y", entity.field_70163_u);
                entryTable.put("Z", entity.field_70161_v);
                entityTable.put(i, entryTable);
            }
            return new Object[]{entityTable, entityTable.size(), count};
        });
    }
}

