/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public interface IReinforcedBlock {
    public static final Map<Block, Block> VANILLA_TO_SECURITYCRAFT = new LinkedHashMap<Block, Block>();

    public List<Block> getVanillaBlocks();

    default public IBlockState convertToReinforcedState(IBlockState state) {
        return ((Block)this).func_176203_a(state.func_177230_c().func_176201_c(state));
    }

    default public IBlockState convertToVanillaState(IBlockState state) throws IllegalStateException {
        List<Block> vanillaBlocks = this.getVanillaBlocks();
        if (vanillaBlocks.size() > 1) {
            throw new IllegalStateException(state.func_177230_c().getRegistryName() + " has more than 1 vanilla counterpart, but does not override convertToVanillaState! Cannot determine vanilla state.");
        }
        return vanillaBlocks.get(0).func_176203_a(state.func_177230_c().func_176201_c(state));
    }

    default public ItemStack convertToReinforcedStack(ItemStack stackToConvert, Block blockToConvert) {
        return new ItemStack((Block)this, 1, stackToConvert.func_77960_j());
    }

    default public ItemStack convertToVanillaStack(ItemStack stackToConvert) throws IllegalStateException {
        List<Block> vanillaBlocks = this.getVanillaBlocks();
        if (vanillaBlocks.size() > 1) {
            throw new IllegalStateException(stackToConvert.func_77973_b().getRegistryName() + " has more than 1 vanilla counterpart, but does not override convertToVanillaStack! Cannot determine vanilla stack.");
        }
        return new ItemStack(vanillaBlocks.get(0), 1, stackToConvert.func_77960_j());
    }
}

