/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class LaserBlockBlockEntity
extends LinkableBlockEntity
implements IInventoryChangedListener {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(() -> ((LaserBlockBlockEntity)this).func_174877_v(), 50);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Map<EnumFacing, Boolean> sideConfig;
    private IItemHandler insertOnlyHandler;
    private IItemHandler lensHandler;
    private LensContainer lenses = new LensContainer(6);
    private long lastToggleTime;

    public LaserBlockBlockEntity() {
        this.lenses.func_110134_a(this);
        this.sideConfig = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.values()) {
            this.sideConfig.put(dir, true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("sideConfig", (NBTBase)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
        for (int i = 0; i < this.lenses.func_70302_i_(); ++i) {
            tag.func_74782_a("lens" + i, (NBTBase)this.lenses.func_70301_a(i).func_77955_b(new NBTTagCompound()));
        }
        return tag;
    }

    public static NBTTagCompound saveSideConfig(Map<EnumFacing, Boolean> sideConfig) {
        NBTTagCompound sideConfigTag = new NBTTagCompound();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.func_74757_a(dir.func_176610_l(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.func_74775_l("sideConfig"));
        for (int i = 0; i < this.lenses.func_70302_i_(); ++i) {
            this.lenses.setItemExclusively(i, new ItemStack(tag.func_74775_l("lens" + i)));
        }
        this.lenses.func_70296_d();
    }

    public static Map<EnumFacing, Boolean> loadSideConfig(NBTTagCompound sideConfigTag) {
        EnumMap<EnumFacing, Boolean> sideConfig = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.values()) {
            if (sideConfigTag.func_150297_b(dir.func_176610_l(), 1)) {
                sideConfig.put(dir, sideConfigTag.func_74767_n(dir.func_176610_l()));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedTEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            Option option = ((ILinkedAction.OptionChanged)action).option;
            if (option.getName().equals(this.disabled.getName())) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals(this.ignoreOwner.getName())) {
                this.ignoreOwner.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
                this.onRemoveRedstoneModule();
            } else {
                if (!option.getName().equals(this.respectInvisibility.getName())) throw new UnsupportedOperationException("Unhandled option synchronization in laser block! " + option.getName());
                this.respectInvisibility.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            ItemStack module = moduleInserted.stack;
            boolean toggled = moduleInserted.wasModuleToggled;
            this.insertModule(module, toggled);
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            ModuleType module = moduleRemoved.moduleType;
            boolean toggled = moduleRemoved.wasModuleToggled;
            this.removeModule(module, toggled);
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            Owner owner = ((ILinkedAction.OwnerChanged)action).newOwner;
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((ILinkedAction.StateChanged)action).property == LaserBlock.POWERED) {
                if (this.timeSinceLastToggle() < 500L) {
                    this.setLastToggleTime(System.currentTimeMillis());
                } else {
                    int signalLength = this.getSignalLength();
                    this.setLastToggleTime(System.currentTimeMillis());
                    this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177231_a((IProperty)LaserBlock.POWERED));
                    BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.laserBlock);
                    if (signalLength > 0) {
                        this.field_145850_b.func_175684_a(this.field_174879_c, SCContent.laserBlock, signalLength);
                    }
                }
            }
        }
        excludedTEs.add(this);
        this.propagate(action, excludedTEs);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.onRemoveRedstoneModule();
        }
        super.onOptionChanged(option);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onInsertDisguiseModule(this, stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onRemoveDisguiseModule(this, stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            this.onRemoveRedstoneModule();
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    private void onRemoveRedstoneModule() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)LaserBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.laserBlock);
        }
    }

    public void func_76316_a(IInventory container) {
        if (this.field_145850_b == null) {
            return;
        }
        for (EnumFacing direction : EnumFacing.values()) {
            int i = 1;
            BlockPos pos = this.func_174877_v();
            BlockPos modifiedPos = pos.func_177967_a(direction, i);
            IBlockState stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
            ArrayList<BlockPos> positionsToUpdate = new ArrayList<BlockPos>();
            while (i < ConfigHandler.laserBlockRange && stateAtModifiedPos.func_177230_c() != SCContent.laserBlock) {
                modifiedPos = pos.func_177967_a(direction, ++i);
                stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
                positionsToUpdate.add(modifiedPos);
            }
            TileEntity be = this.field_145850_b.func_175625_s(modifiedPos);
            if (!(be instanceof LaserBlockBlockEntity)) continue;
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)be;
            otherLaser.getLensContainer().setItemExclusively(direction.func_176734_d().ordinal(), this.lenses.func_70301_a(direction.ordinal()));
            if (!this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToDimension((IMessage)new UpdateLaserColors(positionsToUpdate), this.field_145850_b.field_73011_w.getDimension());
            }
            this.field_145850_b.func_184138_a(modifiedPos, stateAtModifiedPos, stateAtModifiedPos, 2);
        }
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? this.getNormalHandler() : this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper((IInventory)this.lenses);
        }
        return this.insertOnlyHandler;
    }

    private IItemHandler getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = new InvWrapper((IInventory)this.lenses);
        }
        return this.lensHandler;
    }

    public LensContainer getLensContainer() {
        return this.lenses;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        DisguisableBlockEntity.onLoad(this);
    }

    @Override
    public void readOptions(NBTTagCompound tag) {
        if (tag.func_74764_b("enabled")) {
            tag.func_74757_a("disabled", !tag.func_74767_n("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        DisguisableBlockEntity.onInvalidate(this);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isConsideredInvisible(EntityLivingBase entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    public void setLastToggleTime(long lastToggleTime) {
        this.lastToggleTime = lastToggleTime;
    }

    public long getLastToggleTime() {
        return this.lastToggleTime;
    }

    public long timeSinceLastToggle() {
        return System.currentTimeMillis() - this.getLastToggleTime();
    }

    public void applyNewSideConfig(Map<EnumFacing, Boolean> sideConfig, EntityPlayer player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((EnumFacing)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (EnumFacing direction : EnumFacing.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(EnumFacing direction, boolean enabled, EntityPlayer player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(EnumFacing direction, boolean enabled, EntityPlayer player, boolean modifyOtherLaser) {
        TileEntity te;
        int i = 1;
        BlockPos pos = this.func_174877_v();
        BlockPos modifiedPos = pos.func_177967_a(direction, i);
        IBlockState ownState = this.field_145850_b.func_180495_p(pos);
        IBlockState stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
        while (i < ConfigHandler.laserBlockRange && stateAtModifiedPos.func_177230_c() != SCContent.laserBlock) {
            modifiedPos = pos.func_177967_a(direction, ++i);
            stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
        }
        if (modifyOtherLaser && (te = this.field_145850_b.func_175625_s(modifiedPos)) instanceof LaserBlockBlockEntity) {
            ((LaserBlockBlockEntity)te).sideConfig.put(direction.func_176734_d(), enabled);
        }
        if (enabled) {
            Block block = ownState.func_177230_c();
            if (block instanceof LaserBlock) {
                ((LaserBlock)block).setLaser(this.field_145850_b, pos, direction, player);
            }
        } else {
            int boundType = LaserFieldBlock.getBoundType(direction);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.func_177230_c() == SCContent.laserField && (Integer)stateToCheck.func_177229_b((IProperty)LaserFieldBlock.BOUNDTYPE) == boundType, this.field_145850_b, pos, direction);
        }
    }

    public Map<EnumFacing, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(EnumFacing dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block != SCContent.laserBlock) {
            return;
        }
        if (this.isEnabled()) {
            ((LaserBlock)block).setLaser(this.field_145850_b, this.field_174879_c, null);
        } else {
            LaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            List thisInsertedModules = this.getInsertedModules();
            List thatInsertedModules = that.getInsertedModules();
            for (ModuleType moduleType : thisInsertedModules) {
                ItemStack thisModule = this.getModule(moduleType);
                if (thatInsertedModules.contains((Object)moduleType) && !ItemStack.areItemStackShareTagsEqual((ItemStack)thisModule, (ItemStack)that.getModule(moduleType))) {
                    return moduleType;
                }
                bothInsertedModules.put(thisModule.func_77946_l(), this.isModuleEnabled(moduleType));
                this.removeModule(moduleType, false);
            }
            for (ModuleType moduleType : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(moduleType).func_77946_l(), that.isModuleEnabled(moduleType));
                that.removeModule(moduleType, false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(moduleType, false), that);
            }
            this.readOptions(that.writeOptions(new NBTTagCompound()));
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.func_77973_b();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

