/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SecretSignBlockEntity
extends TileEntitySign
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.BooleanOption isSecret = new Option.BooleanOption("isSecret", true);
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.owner.load(tag);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isSecret};
    }

    public boolean isSecret() {
        return (Boolean)this.isSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(EntityPlayer player) {
        return !this.isSecret() || this.isOwnedBy((Entity)player) || this.isAllowed((Entity)player);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
        if (shouldBeEnabled) {
            this.onModuleInserted(this.getModule(module), module, true);
        } else {
            this.onModuleRemoved(this.getModule(module), module, true);
        }
    }

    @Override
    public World myLevel() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos myPos() {
        return this.field_174879_c;
    }
}

