/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements IEMPAffectedBE,
ITickable,
IInventoryChangedListener,
SingleLensMenu.SingleLensContainer {
    public static final float HALF_PI = 1.5707964f;
    public static final float TWO_PI = (float)Math.PI * 2;
    private static final Map<EntityPlayerMP, Set<SecurityCameraBlockEntity>> RECENTLY_UNVIEWED_CAMERAS = new HashMap<EntityPlayerMP, Set<SecurityCameraBlockEntity>>();
    private static final Set<Long> FORCE_LOADED_CAMERA_CHUNKS = new HashSet<Long>();
    private static int forceLoadingCounter = 0;
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private final Set<Long> chunkForceLoadQueue = new HashSet<Long>();
    private final Map<UUID, ChunkTrackingView> cameraFeedChunks = new HashMap<UUID, ChunkTrackingView>();
    private final Map<UUID, Set<Long>> linkedFrames = new HashMap<UUID, Set<Long>>();
    private int maxChunkLoadingRadius = 0;
    private boolean down = false;
    private boolean initialized = false;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "opacity", 100, 0, 255, 1);
    private IItemHandler insertOnlyHandler;
    private IItemHandler lensHandler;
    private LensContainer lens = new LensContainer(1);
    private int playersViewing = 0;
    private ForgeChunkManager.Ticket chunkTicket;

    public SecurityCameraBlockEntity() {
        this.lens.func_110134_a(this);
    }

    public void func_73660_a() {
        if (!this.initialized) {
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SecurityCameraBlock.FACING), this.initialZoom);
            }
            this.initialized = true;
        }
        if (!this.field_145850_b.field_72995_K && !this.chunkForceLoadQueue.isEmpty()) {
            HashSet<Long> queueCopy = new HashSet<Long>(this.chunkForceLoadQueue);
            for (Long chunkPosLong : queueCopy) {
                if (forceLoadingCounter > 16) break;
                ChunkPos chunkPos = new ChunkPos((int)(chunkPosLong & 0xFFFFFFFFFFFFFFFFL), (int)(chunkPosLong >> 32));
                if (!FORCE_LOADED_CAMERA_CHUNKS.contains(chunkPosLong)) {
                    this.getTicketAndForceChunk(chunkPos);
                    FORCE_LOADED_CAMERA_CHUNKS.add(chunkPosLong);
                    ++forceLoadingCounter;
                }
                this.chunkForceLoadQueue.remove(chunkPosLong);
            }
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                GlobalPos cameraPos;
                this.cameraRotation = (Double)this.customRotationOption.get();
                if (this.field_145850_b.field_72995_K && this.cameraRotation != this.oCameraRotation && FrameFeedHandler.hasFeed(cameraPos = GlobalPos.of(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c))) {
                    FrameFeedHandler.getFeed(cameraPos).requestFrustumUpdate();
                }
                return;
            }
            if (this.down) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
                if (this.oCameraRotation >= 6.2831854820251465) {
                    this.cameraRotation %= 6.2831854820251465;
                    this.oCameraRotation %= 6.2831854820251465;
                }
                return;
            }
            if (this.addToRotation && this.getCameraRotation() <= 1.5707963705062866) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.getCameraRotation() >= -1.5707963705062866) {
                this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void shutDown() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IEMPAffectedBE.super.shutDown();
        if (state.func_177230_c() == SCContent.securityCamera && ((Boolean)state.func_177229_b((IProperty)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.func_175667_e(this.field_174879_c) || !(this.field_145850_b.func_175625_s(this.field_174879_c) instanceof SecurityCameraBlockEntity)) {
            this.unlinkAllFrames();
        }
        if (!this.field_145850_b.field_72995_K && this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    @Override
    public void onOwnerChanged(IBlockState state, World level, BlockPos pos, EntityPlayer player, Owner oldOwner, Owner newOwner) {
        this.unlinkAllFrames();
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74780_a("camera_rotation", this.cameraRotation);
        tag.func_74757_a("add_to_rotation", this.addToRotation);
        tag.func_74757_a("ShutDown", this.shutDown);
        tag.func_74768_a("PlayersViewing", this.playersViewing);
        tag.func_74782_a("lens", (NBTBase)this.lens.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        tag.func_74776_a("initial_x_rotation", this.initialXRotation);
        tag.func_74776_a("initial_y_rotation", this.initialYRotation);
        tag.func_74776_a("initial_zoom", this.initialZoom);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("camera_rotation")) {
            double newCamRotation;
            this.cameraRotation = newCamRotation = tag.func_74769_h("camera_rotation");
            this.oCameraRotation = newCamRotation;
            this.addToRotation = tag.func_74767_n("add_to_rotation");
        }
        this.shutDown = tag.func_74767_n("ShutDown");
        this.playersViewing = tag.func_74762_e("PlayersViewing");
        this.lens.func_70299_a(0, new ItemStack(tag.func_74775_l("lens")));
        this.initialXRotation = tag.func_74760_g("initial_x_rotation");
        this.initialYRotation = tag.func_74760_g("initial_y_rotation");
        if (tag.func_74764_b("initial_zoom")) {
            this.initialZoom = tag.func_74760_g("initial_zoom");
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? this.getNormalHandler() : this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper((IInventory)this.lens);
        }
        return this.insertOnlyHandler;
    }

    private IItemHandler getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = new InvWrapper((IInventory)this.lens);
        }
        return this.lensHandler;
    }

    public void func_76316_a(IInventory container) {
        if (this.field_145850_b == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public LensContainer getLensContainer() {
        return this.lens;
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            IBlockState newState = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)newState.func_177229_b((IProperty)SecurityCameraBlock.FACING)).func_176734_d()), this.func_145838_q(), false);
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    public void onLoad() {
        IBlockState state;
        super.onLoad();
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof SecurityCameraBlock) {
            this.down = state.func_177229_b((IProperty)SecurityCameraBlock.FACING) == EnumFacing.DOWN;
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    private void makeEveryoneStopViewingTheCamera() {
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayer p : ((WorldServer)this.field_145850_b).field_73010_i) {
                SecurityCamera camera;
                EntityPlayerMP player = (EntityPlayerMP)p;
                if (!(player.func_175398_C() instanceof SecurityCamera) || !(camera = (SecurityCamera)player.func_175398_C()).func_180425_c().equals((Object)this.field_174879_c)) continue;
                camera.stopViewing(player);
            }
        }
    }

    public void startViewing() {
        ++this.playersViewing;
        this.func_70296_d();
        this.sync();
    }

    public void stopViewing() {
        --this.playersViewing;
        this.func_70296_d();
        this.sync();
    }

    public boolean isSomeoneViewing() {
        return this.playersViewing > 0;
    }

    public void linkFrameForPlayer(EntityPlayerMP player, BlockPos framePos, int chunkLoadingDistance) {
        Set playerViewedFrames = this.linkedFrames.computeIfAbsent(player.func_110124_au(), uuid -> new HashSet());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        ChunkPos cameraChunkPos = new ChunkPos(this.field_174879_c);
        Long cameraChunkPosLong = ChunkPos.func_77272_a((int)cameraChunkPos.field_77276_a, (int)cameraChunkPos.field_77275_b);
        BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.track(this);
        this.requestChunkSending(player, chunkLoadingDistance);
        if (!FORCE_LOADED_CAMERA_CHUNKS.contains(cameraChunkPosLong)) {
            this.getTicketAndForceChunk(cameraChunkPos);
            this.chunkForceLoadQueue.add(cameraChunkPosLong);
        }
        for (int x = cameraChunkPos.field_77276_a - chunkLoadingDistance; x <= cameraChunkPos.field_77276_a + chunkLoadingDistance; ++x) {
            for (int z = cameraChunkPos.field_77275_b - chunkLoadingDistance; z <= cameraChunkPos.field_77275_b + chunkLoadingDistance; ++z) {
                Long forceLoadingPos = ChunkPos.func_77272_a((int)x, (int)z);
                ((WorldServer)this.field_145850_b).func_184164_w().func_187302_c(x, z).func_187276_a(player);
                if (FORCE_LOADED_CAMERA_CHUNKS.contains(forceLoadingPos)) continue;
                this.chunkForceLoadQueue.add(forceLoadingPos);
            }
        }
        if (chunkLoadingDistance > this.maxChunkLoadingRadius) {
            this.maxChunkLoadingRadius = chunkLoadingDistance;
        }
        playerViewedFrames.add(framePos.func_177986_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void unlinkFrameForPlayer(UUID playerUUID, BlockPos framePos) {
        if (this.linkedFrames.containsKey(playerUUID)) {
            Set<Long> linkedFramesPerPlayer = this.linkedFrames.get(playerUUID);
            ChunkPos cameraChunkPos = new ChunkPos(this.field_174879_c);
            if (framePos != null) {
                linkedFramesPerPlayer.remove(framePos.func_177986_g());
            }
            if (framePos == null || linkedFramesPerPlayer.isEmpty()) {
                PlayerList playerList = this.field_145850_b.func_73046_m().func_184103_al();
                EntityPlayerMP player = playerList.func_177451_a(playerUUID);
                int viewDistance = playerList.func_72395_o();
                this.linkedFrames.remove(playerUUID);
                if (this.field_145850_b instanceof WorldServer) {
                    SecurityCameraBlockEntity.untrackAllInvisibleChunks((WorldServer)this.field_145850_b, cameraChunkPos, this.maxChunkLoadingRadius, viewDistance, player);
                }
            }
            if (this.linkedFrames.isEmpty()) {
                SecurityCameraBlockEntity.addRecentlyUnviewedCamera(this);
                BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.stopTracking(this);
                for (int x = cameraChunkPos.field_77276_a - this.maxChunkLoadingRadius; x <= cameraChunkPos.field_77276_a + this.maxChunkLoadingRadius; ++x) {
                    for (int z = cameraChunkPos.field_77275_b - this.maxChunkLoadingRadius; z <= cameraChunkPos.field_77275_b + this.maxChunkLoadingRadius; ++z) {
                        ChunkPos chunkPos = new ChunkPos(x, z);
                        Long chunkPosLong = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
                        if (!FORCE_LOADED_CAMERA_CHUNKS.contains(chunkPosLong) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getTileEntitiesWithCondition(this.field_145850_b, be -> be.shouldKeepChunkForceloaded(chunkPos)).isEmpty()) continue;
                        this.unforceChunk(chunkPos);
                        FORCE_LOADED_CAMERA_CHUNKS.remove(chunkPosLong);
                    }
                }
                this.maxChunkLoadingRadius = 0;
            }
        }
    }

    public static void untrackAllInvisibleChunks(WorldServer world, ChunkPos centerPos, int chunkUntrackingDistance, int playerViewDistance, EntityPlayerMP player) {
        ChunkPos playerChunkPos = new ChunkPos(player.func_180425_c());
        for (int cx = centerPos.field_77276_a - chunkUntrackingDistance; cx <= centerPos.field_77276_a + chunkUntrackingDistance; ++cx) {
            for (int cz = centerPos.field_77275_b - chunkUntrackingDistance; cz <= centerPos.field_77275_b + chunkUntrackingDistance; ++cz) {
                if (cx >= playerChunkPos.field_77276_a - playerViewDistance && cx <= playerChunkPos.field_77276_a + playerViewDistance && cz >= playerChunkPos.field_77275_b - playerViewDistance && cz <= playerChunkPos.field_77275_b + playerViewDistance || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getTileEntitiesWithCondition((World)world, be -> be.shouldKeepChunkTracked(player.func_110124_au(), centerPos.field_77276_a, centerPos.field_77275_b)).isEmpty()) continue;
                world.func_184164_w().func_187302_c(cx, cz).func_187277_b(player);
            }
        }
    }

    private void getTicketAndForceChunk(ChunkPos chunkPos) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)SecurityCraft.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunkPos);
    }

    private void unforceChunk(ChunkPos chunkPos) {
        if (this.chunkTicket != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunkPos);
        }
    }

    public void unlinkFrameForAllPlayers(BlockPos framePos) {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, framePos);
        }
    }

    public void unlinkAllFrames() {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, null);
        }
        if (this.field_145850_b.field_72995_K) {
            FrameFeedHandler.removeAllFrameLinks(GlobalPos.of(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c));
        }
    }

    public boolean hasPlayerFrameLink(EntityPlayer player) {
        return this.linkedFrames.containsKey(player.func_110124_au());
    }

    public boolean isFrameLinked(EntityPlayer player, BlockPos framePos) {
        return this.hasPlayerFrameLink(player) && this.linkedFrames.get(player.func_110124_au()).contains(framePos.func_177986_g());
    }

    public void requestChunkSending(EntityPlayerMP player, int chunkLoadingDistance) {
        this.setChunkLoadingDistance(player, chunkLoadingDistance);
    }

    public ChunkTrackingView getCameraFeedChunks(EntityPlayerMP player) {
        return this.cameraFeedChunks.get(player.func_110124_au());
    }

    public void clearCameraFeedChunks(EntityPlayerMP player) {
        this.cameraFeedChunks.remove(player.func_110124_au());
    }

    public void setChunkLoadingDistance(EntityPlayerMP player, int chunkLoadingDistance) {
        this.cameraFeedChunks.put(player.func_110124_au(), new ChunkTrackingView(new ChunkPos(this.field_174879_c), chunkLoadingDistance));
    }

    public boolean shouldKeepChunkTracked(UUID uuid, int chunkX, int chunkZ) {
        return this.cameraFeedChunks.containsKey(uuid) && this.cameraFeedChunks.get(uuid).contains(chunkX, chunkZ);
    }

    public boolean shouldKeepChunkForceloaded(ChunkPos chunkPos) {
        ChunkPos cameraPos = new ChunkPos(this.field_174879_c);
        return chunkPos.field_77276_a >= cameraPos.field_77276_a - this.maxChunkLoadingRadius && chunkPos.field_77276_a <= cameraPos.field_77276_a + this.maxChunkLoadingRadius && chunkPos.field_77275_b >= cameraPos.field_77275_b - this.maxChunkLoadingRadius && chunkPos.field_77275_b <= cameraPos.field_77275_b + this.maxChunkLoadingRadius;
    }

    public static void addRecentlyUnviewedCamera(SecurityCameraBlockEntity camera) {
        for (EntityPlayerMP player : camera.field_145850_b.func_73046_m().func_184103_al().func_181057_v()) {
            Set unviewingCameras = RECENTLY_UNVIEWED_CAMERAS.computeIfAbsent(player, p -> new HashSet());
            unviewingCameras.add(camera);
        }
    }

    public static boolean hasRecentlyUnviewedCameras(EntityPlayerMP player) {
        return RECENTLY_UNVIEWED_CAMERAS.containsKey(player);
    }

    public static Set<SecurityCameraBlockEntity> fetchRecentlyUnviewedCameras(EntityPlayerMP player) {
        return RECENTLY_UNVIEWED_CAMERAS.remove(player);
    }

    public static void resetForceLoadingCounter() {
        forceLoadingCounter = 0;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public boolean shouldRotate() {
        return (Boolean)this.shouldRotateOption.get();
    }

    public float getDefaultXRotation() {
        return this.down ? 75.0f : 30.0f;
    }

    public float getDefaultYRotation(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public void setDefaultViewingDirection(EnumFacing facing, float zoom) {
        this.setDefaultViewingDirection(this.getDefaultXRotation(), this.getDefaultYRotation(facing), zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.func_70296_d();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }

    public static class ChunkTrackingView {
        protected final ChunkPos center;
        protected final int viewDistance;

        public ChunkTrackingView(ChunkPos center, int viewDistance) {
            this.center = center;
            this.viewDistance = viewDistance;
        }

        public boolean contains(int x, int z) {
            return Utils.isInViewDistance(this.center.field_77276_a, this.center.field_77275_b, this.viewDistance, x, z);
        }

        public ChunkPos center() {
            return this.center;
        }

        public int viewDistance() {
            return this.viewDistance;
        }
    }
}

