/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AlarmBlock
extends OwnableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public AlarmBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.field_181083_K = MapColor.field_151645_D;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        AlarmBlockEntity te;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AlarmBlockEntity && (te = (AlarmBlockEntity)tile).isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                if (te.isDisabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    SecurityCraft.network.sendTo((IMessage)new OpenScreen(OpenScreen.DataType.ALARM, pos), (EntityPlayerMP)player);
                }
            }
            return true;
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != null && side.func_176740_k() == EnumFacing.Axis.Y;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176198_a(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? facing : EnumFacing.DOWN)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            world.func_175684_a(pos, state.func_177230_c(), 5);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            this.updateState(world, pos, state);
            world.func_175684_a(pos, state.func_177230_c(), 5);
        }
    }

    public void onNeighborChange(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        World world = (World)w;
        if (world.field_72995_K) {
            return;
        }
        this.updateState(world, pos, world.func_180495_p(pos));
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (!world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (!ConfigHandler.vanillaToolBlockBreaking && te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float threePx = 0.1875f;
        float ySideMin = 0.5f - threePx;
        float ySideMax = 0.5f + threePx;
        float hSideMin = 0.5f - threePx;
        float hSideMax = 0.5f + threePx;
        float px = 0.0625f;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (SwitchEnumFacing.FACING_LOOKUP[facing.ordinal()]) {
            case 1: {
                return new AxisAlignedBB(0.0, (double)(ySideMin - px), (double)(hSideMin - px), 0.5, (double)(ySideMax + px), (double)(hSideMax + px));
            }
            case 2: {
                return new AxisAlignedBB(0.5, (double)(ySideMin - px), (double)(hSideMin - px), 1.0, (double)(ySideMax + px), (double)(hSideMax + px));
            }
            case 3: {
                return new AxisAlignedBB((double)(hSideMin - px), (double)(ySideMin - px), 0.0, (double)(hSideMax + px), (double)(ySideMax + px), 0.5);
            }
            case 4: {
                return new AxisAlignedBB((double)(hSideMin - px), (double)(ySideMin - px), 0.5, (double)(hSideMax + px), (double)(ySideMax + px), 1.0);
            }
            case 5: {
                return new AxisAlignedBB((double)(0.5f - threePx - px), 0.0, (double)(0.5f - threePx - px), (double)(0.5f + threePx + px), 0.5, (double)(0.5f + threePx + px));
            }
            case 6: {
                return new AxisAlignedBB((double)(0.5f - threePx - px), 0.5, (double)(0.5f - threePx - px), (double)(0.5f + threePx + px), 1.0, (double)(0.5f + threePx + px));
            }
        }
        return state.func_185900_c(source, pos);
    }

    private void updateState(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != SCContent.alarm) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AlarmBlockEntity) {
            AlarmBlockEntity te = (AlarmBlockEntity)tile;
            if (world.func_175687_A(pos) > 0) {
                boolean isPowered = te.isPowered();
                if (!isPowered) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                    te.setPowered(true);
                }
            } else {
                boolean isPowered = te.isPowered();
                if (isPowered) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                    te.setPowered(false);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        boolean lit;
        boolean bl = lit = meta > 6;
        if (lit) {
            meta -= 6;
        }
        switch (meta & 7) {
            case 0: {
                facing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                facing = EnumFacing.EAST;
                break;
            }
            case 2: {
                facing = EnumFacing.WEST;
                break;
            }
            case 3: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                facing = EnumFacing.NORTH;
                break;
            }
            default: {
                facing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        int meta;
        switch (SwitchEnumFacing.FACING_LOOKUP[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()]) {
            case 1: {
                meta = 1;
                break;
            }
            case 2: {
                meta = 2;
                break;
            }
            case 3: {
                meta = 3;
                break;
            }
            case 4: {
                meta = 4;
                break;
            }
            case 6: {
                meta = 0;
                break;
            }
            default: {
                meta = 5;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta += 6;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != EnumFacing.Axis.X) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new AlarmBlockEntity();
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        private SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

