/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay,
IDisguisable {
    public DisguisableBlock(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(level.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185903_a(player, level, pos);
        }
        return super.func_180647_a(state, player, level, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185890_d(world, pos);
        }
        return super.func_180646_a(state, world, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185918_c(world, pos);
        }
        return super.func_180640_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
        } else {
            DisguisableBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return IDisguisable.getDisguisedBlockFaceShape(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return IDisguisable.shouldDisguisedSideBeRendered(state, world, pos, side);
    }

    public static boolean checkForSideTransparency(IBlockAccess world, IBlockState neighborState, BlockPos neighborPos) {
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock.isAir(neighborState, world, neighborPos)) {
            return true;
        }
        return !(neighborBlock instanceof BlockBreakable) || !neighborBlock.getRegistryName().func_110624_b().equals("minecraft");
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world.func_175625_s(pos));
        return disguisedState != null ? disguisedState : state;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (IDisguisable.shouldPickBlockDisguise((IBlockAccess)world, pos, player)) {
            return this.getDisguisedStack((IBlockAccess)world, pos);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new DisguisableBlockEntity();
    }
}

