/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.IronFenceBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableFenceBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ElectrifiedIronFenceBlock
extends OwnableFenceBlock {
    public ElectrifiedIronFenceBlock(Material material) {
        super(material, MapColor.field_151668_h);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean func_176524_e(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this && !(block instanceof BlockFenceGate) && block != SCContent.electrifiedIronFenceGate) {
            if (block.func_176223_P().func_185904_a().func_76218_k()) {
                return block.func_176223_P().func_185904_a() != Material.field_151572_C;
            }
            return false;
        }
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        ElectrifiedIronFenceBlock.hurtOrConvertEntity(world, pos, state, entity);
    }

    public static void hurtOrConvertEntity(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IOwnable)) {
            return;
        }
        IOwnable te = (IOwnable)tile;
        if (te instanceof IEMPAffectedBE && ((IEMPAffectedBE)((Object)te)).isShutDown()) {
            return;
        }
        if (world.field_73011_w.getWorldTime() % 20L != 0L) {
            return;
        }
        if (!entity.func_70089_S() || !state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_186662_g(0.01).func_72326_a(entity.func_174813_aQ())) {
            return;
        }
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            if (te.isOwnedBy(entity)) {
                return;
            }
        } else {
            if (((OwnableBlockEntity)world.func_175625_s(pos)).allowsOwnableEntity(entity)) {
                return;
            }
            if (!world.field_72995_K) {
                EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
                entity.func_70077_a(lightning);
                entity.func_70066_B();
                return;
            }
        }
        entity.func_70097_a(CustomDamageSources.ELECTRICITY, 6.0f);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new IronFenceBlockEntity();
    }
}

