/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class InventoryScannerBlock
extends DisguisableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool HORIZONTAL = PropertyBool.func_177716_a((String)"horizontal");

    public InventoryScannerBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.5f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState north = world.func_180495_p(pos.func_177978_c());
            IBlockState south = world.func_180495_p(pos.func_177968_d());
            IBlockState west = world.func_180495_p(pos.func_177976_e());
            IBlockState east = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isFacingAnotherScanner(world, pos)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof InventoryScannerBlockEntity) {
                InventoryScannerBlockEntity te = (InventoryScannerBlockEntity)tile;
                if (te.isDisabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.INVENTORY_SCANNER.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("tile.securitycraft:inventoryScanner.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), TextFormatting.RED);
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (world.field_72995_K) {
            return;
        }
        this.setDefaultFacing(world, pos, state);
        InventoryScannerBlock.checkAndPlaceAppropriately(world, pos, entity, false);
    }

    public static void checkAndPlaceAppropriately(World world, BlockPos pos, EntityLivingBase player, boolean force) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
        InventoryScannerBlockEntity thisTe = (InventoryScannerBlockEntity)world.func_175625_s(pos);
        if (connectedScanner == null) {
            return;
        }
        if (!force) {
            if (connectedScanner.isDisabled()) {
                thisTe.setDisabled(true);
                return;
            }
        } else {
            thisTe.setDisabled(false);
            connectedScanner.setDisabled(false);
        }
        if (player instanceof EntityPlayer ? !connectedScanner.isOwnedBy((Entity)player) : !connectedScanner.getOwner().owns(thisTe)) {
            return;
        }
        boolean horizontal = false;
        if (((Boolean)world.func_180495_p(connectedScanner.func_174877_v()).func_177229_b((IProperty)HORIZONTAL)).booleanValue()) {
            horizontal = true;
        }
        thisTe.setHorizontal(horizontal);
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        int loopBoundary = facing == EnumFacing.WEST || facing == EnumFacing.EAST ? Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()) : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()) : 0);
        for (int i = 1; i < loopBoundary; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.inventoryScannerField) continue;
            return;
        }
        Option<?>[] customOptions = thisTe.customOptions();
        for (int i = 1; i < loopBoundary; ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            world.func_175656_a(offsetPos, SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(horizontal)));
            TileEntity te = world.func_175625_s(offsetPos);
            if (!(te instanceof IOwnable)) continue;
            ((IOwnable)te).setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
        }
        for (ModuleType type : connectedScanner.getInsertedModules()) {
            thisTe.insertModule(connectedScanner.getModule(type), false);
        }
        ((Option.BooleanOption)customOptions[0]).setValue(connectedScanner.isHorizontal());
        ((Option.BooleanOption)customOptions[1]).setValue(connectedScanner.doesFieldSolidify());
        ((Option.BooleanOption)customOptions[2]).setValue(false);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(fromPos).func_177230_c() != SCContent.inventoryScannerField) {
            InventoryScannerBlock.checkAndPlaceAppropriately(world, pos, null, false);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos, state, null);
        TileEntity tile = world.func_175625_s(pos);
        BlockUtils.removeInSequence((direction, stateToCheck) -> {
            if (stateToCheck.func_177230_c() != SCContent.inventoryScannerField) {
                return false;
            }
            EnumFacing stateToCheckFacing = (EnumFacing)stateToCheck.func_177229_b((IProperty)FACING);
            return stateToCheckFacing == direction || stateToCheckFacing == direction.func_176734_d();
        }, world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        if (tile instanceof InventoryScannerBlockEntity) {
            InventoryScannerBlockEntity te = (InventoryScannerBlockEntity)tile;
            for (int i = 10; i < te.func_70302_i_(); ++i) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((ItemStack)te.getContents().get(i)));
            }
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)te.getLensContainer());
            if (te.isProvidingPower()) {
                world.func_175685_c(pos, (Block)this, false);
                BlockUtils.updateIndirectNeighbors(world, pos, (Block)this);
            }
        }
        if (connectedScanner != null) {
            for (int i = 0; i < connectedScanner.getContents().size(); ++i) {
                connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
            }
            connectedScanner.getLensContainer().func_174888_l();
        }
        super.func_180663_b(world, pos, state);
    }

    private boolean isFacingAnotherScanner(World world, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(world, pos) != null;
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(World world, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(world, pos, world.func_180495_p(pos), null);
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(World world, BlockPos pos, IBlockState stateAtPos, Consumer<OwnableBlockEntity> fieldModifier) {
        EnumFacing facing = (EnumFacing)stateAtPos.func_177229_b((IProperty)FACING);
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>();
        for (int i = 0; i <= ConfigHandler.inventoryScannerRange; ++i) {
            boolean isField;
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            IBlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            boolean bl = isField = block == SCContent.inventoryScannerField;
            if (!(isField || state.func_177230_c().isAir(state, (IBlockAccess)world, offsetPos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || block == SCContent.inventoryScanner)) {
                return null;
            }
            if (isField) {
                fields.add(offsetPos);
            }
            if (block != SCContent.inventoryScanner || state.func_177229_b((IProperty)FACING) != facing.func_176734_d()) continue;
            if (fieldModifier != null) {
                fields.stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).forEach(be -> fieldModifier.accept((OwnableBlockEntity)be));
            }
            return (InventoryScannerBlockEntity)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (!(te instanceof InventoryScannerBlockEntity)) {
            return 0;
        }
        return ((InventoryScannerBlockEntity)te).isProvidingPower() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177230_c() != this ? 0 : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)HORIZONTAL) != false ? 4 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HORIZONTAL});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new InventoryScannerBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public static class DoorActivator
    implements Function<Object, IDoorActivator>,
    IDoorActivator {
        private List<Block> blocks = Arrays.asList(SCContent.inventoryScanner);

        @Override
        public IDoorActivator apply(Object o) {
            return this;
        }

        @Override
        public boolean isPowering(World world, BlockPos pos, IBlockState state, TileEntity te, EnumFacing direction, int distance) {
            return ((InventoryScannerBlockEntity)te).isProvidingPower();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

