/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blocks.KeycardLockBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class KeycardLockFloorCeilingBlock
extends KeycardLockBlock {
    public static final PropertyBool FLOOR = PropertyBool.func_177716_a((String)"floor");
    public static final AxisAlignedBB FLOOR_NS;
    public static final AxisAlignedBB FLOOR_EW;
    public static final AxisAlignedBB CEILING_NS;
    public static final AxisAlignedBB CEILING_EW;

    public KeycardLockFloorCeilingBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FLOOR, (Comparable)Boolean.valueOf(true)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)FLOOR)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case NORTH: {
                    return FLOOR_NS;
                }
                case EAST: {
                    return FLOOR_EW;
                }
                case SOUTH: {
                    return FLOOR_NS;
                }
                case WEST: {
                    return FLOOR_EW;
                }
            }
            return field_185506_k;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return CEILING_NS;
            }
            case EAST: {
                return CEILING_EW;
            }
            case SOUTH: {
                return CEILING_NS;
            }
            case WEST: {
                return CEILING_EW;
            }
        }
        return field_185506_k;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(placer == null ? EnumFacing.NORTH : placer.func_174811_aO())).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FLOOR, (Comparable)Boolean.valueOf(facing == EnumFacing.UP));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 4) == 4)).func_177226_a((IProperty)FLOOR, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)FLOOR)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    protected EnumFacing getConnectedDirection(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FLOOR) != false ? EnumFacing.UP : EnumFacing.DOWN;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, FLOOR});
    }

    static {
        float px = 0.0625f;
        FLOOR_NS = new AxisAlignedBB((double)(4.0f * px), (double)(0.0f * px), (double)(3.0f * px), (double)(12.0f * px), (double)(3.0f * px), (double)(13.0f * px));
        FLOOR_EW = new AxisAlignedBB((double)(3.0f * px), (double)(0.0f * px), (double)(4.0f * px), (double)(13.0f * px), (double)(3.0f * px), (double)(12.0f * px));
        CEILING_NS = new AxisAlignedBB((double)(4.0f * px), (double)(13.0f * px), (double)(3.0f * px), (double)(12.0f * px), (double)(16.0f * px), (double)(13.0f * px));
        CEILING_EW = new AxisAlignedBB((double)(3.0f * px), (double)(13.0f * px), (double)(4.0f * px), (double)(13.0f * px), (double)(16.0f * px), (double)(12.0f * px));
    }
}

