/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KeypadTrapDoorBlock
extends BaseIronTrapDoorBlock
implements IDisguisable,
IOverlayDisplay {
    public KeypadTrapDoorBlock(Material mat) {
        super(mat);
        this.func_149711_c(5.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(level.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185903_a(player, level, pos);
        }
        return super.func_180647_a(state, player, level, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
                actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
            }
        } else {
            KeypadTrapDoorBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return IDisguisable.getDisguisedBlockFaceShape(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return IDisguisable.shouldDisguisedSideBeRendered(state, world, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world.func_175625_s(pos));
        return disguisedState != null ? disguisedState : state;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (IDisguisable.shouldPickBlockDisguise((IBlockAccess)world, pos, player)) {
            return this.getDisguisedStack((IBlockAccess)world, pos);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        KeypadTrapdoorBlockEntity be = (KeypadTrapdoorBlockEntity)world.func_175625_s(pos);
        if (((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue() && be.getSignalLength() > 0) {
            return false;
        }
        if (!world.field_72995_K) {
            if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(world, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(state, world, pos, be.getSignalLength());
                } else if (player.func_184586_b(hand).func_77973_b() != SCContent.codebreaker) {
                    be.openPasscodeGUI(world, pos, player);
                }
            }
        }
        return true;
    }

    public void activate(IBlockState state, World world, BlockPos pos, int signalLength) {
        world.func_175656_a(pos, state.func_177231_a((IProperty)field_176283_b));
        this.func_185731_a(null, world, pos, true);
        if (signalLength > 0) {
            world.func_175684_a(pos, (Block)this, signalLength);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity be = world.func_175625_s(pos);
        if (be instanceof IPasscodeProtected) {
            SaltData.removeSalt(((IPasscodeProtected)be).getSaltKey());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176283_b, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new KeypadTrapdoorBlockEntity();
    }

    public static class Convertible
    implements Function<Object, IPasscodeConvertible>,
    IPasscodeConvertible {
        @Override
        public IPasscodeConvertible apply(Object o) {
            return this;
        }

        @Override
        public boolean isUnprotectedBlock(IBlockState state) {
            return state.func_177230_c() == SCContent.reinforcedIronTrapdoor;
        }

        @Override
        public boolean isProtectedBlock(IBlockState state) {
            return state.func_177230_c() == SCContent.keypadTrapdoor;
        }

        @Override
        public boolean protect(EntityPlayer player, World level, BlockPos pos) {
            return this.convert(level, pos, (Block)SCContent.keypadTrapdoor);
        }

        @Override
        public boolean unprotect(EntityPlayer player, World level, BlockPos pos) {
            return this.convert(level, pos, SCContent.reinforcedIronTrapdoor);
        }

        public boolean convert(World level, BlockPos pos, Block convertedBlock) {
            IBlockState state = level.func_180495_p(pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockTrapDoor.field_176284_a);
            BlockTrapDoor.DoorHalf half = (BlockTrapDoor.DoorHalf)state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M);
            TileEntity be = level.func_175625_s(pos);
            if (be instanceof IModuleInventory) {
                ((IModuleInventory)be).dropAllModules();
            }
            NBTTagCompound tag = be.func_189515_b(new NBTTagCompound());
            level.func_175656_a(pos, convertedBlock.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)facing).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockTrapDoor.field_176285_M, (Comparable)half));
            level.func_175625_s(pos).func_145839_a(tag);
            return true;
        }
    }
}

