/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrophySystemBlock
extends DisguisableBlock {
    public TrophySystemBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            this.func_180653_a(world, pos, state, 1.0f, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TrophySystemBlockEntity te;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TrophySystemBlockEntity && (te = (TrophySystemBlockEntity)tile).isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                if (te.isDisabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.TROPHY_SYSTEM.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.065, 0.0, 0.065, 0.935, 0.96, 0.935);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof TrophySystemBlockEntity) {
            ((TrophySystemBlockEntity)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrophySystemBlockEntity) {
            if (!ConfigHandler.vanillaToolBlockBreaking) {
                ((TrophySystemBlockEntity)te).dropAllModules();
            }
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TrophySystemBlockEntity)te).getLensContainer());
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.trophySystem);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TrophySystemBlockEntity();
    }
}

