/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BaseReinforcedBlock
extends OwnableBlock
implements IReinforcedBlock {
    private List<Block> vanillaBlocks;

    public BaseReinforcedBlock(Block ... vB) {
        super(vB[0].func_149688_o(vB[0].func_176223_P()));
        this.vanillaBlocks = Arrays.asList(vB);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.convertToVanillaState(state).func_185887_b(world, pos);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess level, BlockPos pos) {
        return this.convertToVanillaState(state).func_185909_g(level, pos);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this == SCContent.reinforcedSand;
        }
        if (plantable instanceof BlockBush) {
            boolean condition = false;
            if (plantable instanceof BlockLilyPad) {
                condition = state.func_177230_c() == SCContent.fakeWater || state.func_177230_c() == SCContent.reinforcedIce;
            } else if (plantable instanceof BlockDeadBush) {
                boolean bl = condition = state.func_177230_c() == SCContent.reinforcedSand || state.func_177230_c() == SCContent.reinforcedHardenedClay || state.func_177230_c() == SCContent.reinforcedStainedHardenedClay || state.func_177230_c() == SCContent.reinforcedDirt;
            }
            if (plantable instanceof BlockNetherWart) {
                boolean bl = condition = state.func_177230_c() == SCContent.reinforcedSoulSand;
            }
            if (condition) {
                return true;
            }
        }
        switch (plantType) {
            case Desert: {
                return state.func_177230_c() == SCContent.reinforcedSand || state.func_177230_c() == SCContent.reinforcedHardenedClay || state.func_177230_c() == SCContent.reinforcedStainedHardenedClay;
            }
            case Nether: {
                return state.func_177230_c() == SCContent.reinforcedSoulSand;
            }
            case Plains: {
                return state.func_177230_c() == SCContent.reinforcedGrass || state.func_177230_c() == SCContent.reinforcedDirt;
            }
            case Beach: {
                boolean isBeach = state.func_177230_c() == SCContent.reinforcedGrass || state.func_177230_c() == SCContent.reinforcedDirt || state.func_177230_c() == SCContent.reinforcedSand;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        EnumPushReaction originalPushReaction = super.func_149656_h(state);
        return originalPushReaction == EnumPushReaction.DESTROY ? EnumPushReaction.NORMAL : originalPushReaction;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return this.vanillaBlocks;
    }
}

