/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedRedSandstoneAndPurpurSlabsBlock
extends BlockSlab
implements ITileEntityProvider,
IOverlayDisplay,
IReinforcedBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private final boolean isDouble;

    public ReinforcedRedSandstoneAndPurpurSlabsBlock(boolean isDouble, Material blockMaterial) {
        super(blockMaterial);
        this.isDouble = isDouble;
        if (!this.func_176552_j()) {
            this.field_149783_u = true;
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.RED_SANDSTONE)));
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.func_180647_a(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.convertToVanillaState(state).func_185887_b(world, pos);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs2);
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        if (!this.isDouble) {
            for (EnumType et : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, et.getMetadata()));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getTranslationKey();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7))).func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int meta = b0 | ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public boolean func_176552_j() {
        return this.isDouble;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new OwnableBlockEntity();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(SCContent.reinforcedStoneSlabs2, 1, this.func_180651_a(state));
    }

    @Override
    public List<Block> getVanillaBlocks() {
        if (this.isDouble) {
            return Arrays.asList(Blocks.field_180388_cO, Blocks.field_185770_cW);
        }
        return Arrays.asList(Blocks.field_180389_cP, Blocks.field_185771_cX);
    }

    @Override
    public IBlockState convertToReinforcedState(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_180389_cP) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.RED_SANDSTONE)).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
        }
        if (block == Blocks.field_180388_cO) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.RED_SANDSTONE)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        }
        if (block == Blocks.field_185771_cX) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.PURPUR)).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
        }
        if (block == Blocks.field_185770_cW) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.PURPUR)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        }
        return state;
    }

    @Override
    public IBlockState convertToVanillaState(IBlockState state) {
        if (!this.isDouble) {
            switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
                case RED_SANDSTONE: {
                    return Blocks.field_180389_cP.func_176223_P().func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
                }
                case PURPUR: {
                    return Blocks.field_185771_cX.func_176223_P().func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
                }
            }
            return state;
        }
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case RED_SANDSTONE: {
                return Blocks.field_180388_cO.func_176223_P();
            }
            case PURPUR: {
                return Blocks.field_185770_cW.func_176223_P();
            }
        }
        return state;
    }

    @Override
    public ItemStack convertToReinforcedStack(ItemStack stackToConvert, Block blockToConvert) {
        int index = this.getVanillaBlocks().indexOf(blockToConvert);
        if (index >= 0) {
            return new ItemStack((Block)this, 1, index);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack convertToVanillaStack(ItemStack stackToConvert) {
        int meta = stackToConvert.func_77960_j();
        if (meta >= 0 && meta <= 1) {
            return new ItemStack(this.getVanillaBlocks().get(meta));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs2), 1, this.func_176201_c(state) % 8);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return state.func_177230_c() == this;
    }

    public static enum EnumType implements IStringSerializable
    {
        RED_SANDSTONE(0, "red_sandstone", BlockSand.EnumType.RED_SAND.func_176687_c()),
        PURPUR(1, "purpur", MapColor.field_151675_r);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.name;
        }

        public MapColor getColor() {
            return this.color;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] values = EnumType.values();
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = values[i];
            }
        }
    }
}

