/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.server.command.CommandTreeBase;
import org.apache.commons.lang3.RandomStringUtils;

public class OwnerCommand
extends CommandTreeBase {
    public OwnerCommand() {
        this.addSubcommand((ICommand)new SetCommand());
        this.addSubcommand((ICommand)new FillCommand());
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "owner";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/securitycraft owner <set|fill>";
    }

    private static class OwnerChange {
        private final TileEntity be;
        private final Owner oldOwner;

        private OwnerChange(TileEntity be, Owner oldOwner) {
            this.be = be;
            this.oldOwner = oldOwner;
        }
    }

    private static class FillCommand
    extends CommandBase {
        private FillCommand() {
        }

        public String func_71517_b() {
            return "fill";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.securitycraft.owner.fill.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 7 || args[6].equals("player") && args.length < 8) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            World world = sender.func_130014_f_();
            BlockPos firstPosArgs = FillCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
            BlockPos secondPosArgs = FillCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)3, (boolean)false);
            BlockPos from = new BlockPos(Math.min(firstPosArgs.func_177958_n(), secondPosArgs.func_177958_n()), Math.min(firstPosArgs.func_177956_o(), secondPosArgs.func_177956_o()), Math.min(firstPosArgs.func_177952_p(), secondPosArgs.func_177952_p()));
            BlockPos to = new BlockPos(Math.max(firstPosArgs.func_177958_n(), secondPosArgs.func_177958_n()), Math.max(firstPosArgs.func_177956_o(), secondPosArgs.func_177956_o()), Math.max(firstPosArgs.func_177952_p(), secondPosArgs.func_177952_p()));
            int size = (to.func_177958_n() - from.func_177958_n() + 1) * (to.func_177956_o() - from.func_177956_o() + 1) * (to.func_177952_p() - from.func_177952_p() + 1);
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
            if (size > 32768) {
                throw new CommandException("commands.fill.tooManyBlocks", new Object[]{size, 32768});
            }
            if (from.func_177956_o() < 0 || to.func_177956_o() > 255) {
                throw new CommandException("commands.fill.outOfWorld", new Object[0]);
            }
            for (int z = from.func_177952_p(); z <= to.func_177952_p(); z += 16) {
                for (int x = from.func_177958_n(); x <= to.func_177958_n(); x += 16) {
                    if (world.func_175667_e(new BlockPos(x, to.func_177956_o() - from.func_177956_o(), z))) continue;
                    throw new CommandException("commands.fill.outOfWorld", new Object[0]);
                }
            }
            switch (args[6]) {
                case "player": {
                    this.fillOwner(sender, world, from, to, server.func_152358_ax().func_152655_a(args[7]));
                    break;
                }
                case "random": {
                    this.fillRandomOwner(sender, world, from, to);
                    break;
                }
                case "reset": {
                    this.fillOwner(sender, world, from, to, "ownerUUID", "owner");
                    break;
                }
                default: {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
            }
        }

        private void fillRandomOwner(ICommandSender sender, World world, BlockPos from, BlockPos to) throws CommandException {
            this.fillOwner(sender, world, from, to, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
        }

        private void fillOwner(ICommandSender sender, World world, BlockPos from, BlockPos to, GameProfile gameProfile) throws CommandException {
            this.fillOwner(sender, world, from, to, gameProfile.getId().toString(), gameProfile.getName());
        }

        private void fillOwner(ICommandSender sender, World world, BlockPos from, BlockPos to, String uuid, String name) throws CommandException {
            ArrayList<OwnerChange> modifiedBlocks = new ArrayList<OwnerChange>();
            for (int z = from.func_177952_p(); z <= to.func_177952_p(); ++z) {
                for (int y = from.func_177956_o(); y <= to.func_177956_o(); ++y) {
                    for (int x = from.func_177958_n(); x <= to.func_177958_n(); ++x) {
                        IOwnable ownable;
                        Owner previousOwner;
                        BlockPos pos = new BlockPos(x, y, z);
                        TileEntity te = world.func_175625_s(pos);
                        if (!(te instanceof IOwnable) || (previousOwner = (ownable = (IOwnable)te).getOwner()).getUUID().equals(uuid) && previousOwner.getName().equals(name)) continue;
                        Owner oldOwner = ownable.getOwner().copy();
                        ownable.setOwner(uuid, name);
                        modifiedBlocks.add(new OwnerChange((TileEntity)ownable, oldOwner));
                    }
                }
            }
            int blocksModified = modifiedBlocks.size();
            if (blocksModified == 0) {
                throw new CommandException("commands.securitycraft.owner.fill.failed", new Object[0]);
            }
            for (OwnerChange ownerChange : modifiedBlocks) {
                TileEntity be = ownerChange.be;
                BlockPos pos = be.func_174877_v();
                IBlockState state = world.func_180495_p(pos);
                IOwnable ownable = (IOwnable)be;
                ((IOwnable)be).onOwnerChanged(state, world, pos, null, ownerChange.oldOwner, ownable.getOwner());
                ((IOwnable)be).getOwner().setValidated(true);
                world.func_184138_a(pos, state, state, 3);
            }
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, blocksModified);
            FillCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.securitycraft.owner.fill.success", (Object[])new Object[]{blocksModified});
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length >= 1 && args.length <= 3) {
                return FillCommand.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
            }
            if (args.length >= 4 && args.length <= 6) {
                return FillCommand.func_175771_a((String[])args, (int)3, (BlockPos)targetPos);
            }
            if (args.length == 7) {
                return FillCommand.func_71530_a((String[])args, (String[])new String[]{"player", "random", "reset"});
            }
            if (this.func_82358_a(args, 7)) {
                return FillCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return args.length == 8 && args[6].equals("player") && index == 7;
        }
    }

    private static class SetCommand
    extends CommandBase {
        private SetCommand() {
        }

        public String func_71517_b() {
            return "set";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.securitycraft.owner.set.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 4 || args[3].equals("player") && args.length < 5) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            World world = sender.func_130014_f_();
            BlockPos pos = SetCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
            if (!world.func_175667_e(pos)) {
                throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
            }
            switch (args[3]) {
                case "player": {
                    this.setOwner(sender, world, pos, server.func_152358_ax().func_152655_a(args[4]));
                    break;
                }
                case "random": {
                    this.setRandomOwner(sender, world, pos);
                    break;
                }
                case "reset": {
                    this.setOwner(sender, world, pos, "ownerUUID", "owner");
                    break;
                }
                default: {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
            }
        }

        private void setRandomOwner(ICommandSender sender, World world, BlockPos pos) throws CommandException {
            this.setOwner(sender, world, pos, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
        }

        private void setOwner(ICommandSender sender, World world, BlockPos pos, GameProfile gameProfile) throws CommandException {
            this.setOwner(sender, world, pos, gameProfile.getId().toString(), gameProfile.getName());
        }

        private void setOwner(ICommandSender sender, World world, BlockPos pos, String uuid, String name) throws CommandException {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof IOwnable)) {
                throw new CommandException("commands.securitycraft.owner.set.failed", new Object[0]);
            }
            IOwnable ownable = (IOwnable)te;
            Owner previousOwner = ownable.getOwner();
            if (previousOwner.getUUID().equals(uuid) && previousOwner.getName().equals(name)) {
                throw new CommandException("commands.securitycraft.owner.set.failed", new Object[0]);
            }
            IBlockState state = world.func_180495_p(pos);
            Owner oldOwner = ownable.getOwner().copy();
            ownable.setOwner(uuid, name);
            ownable.onOwnerChanged(state, world, pos, null, oldOwner, ownable.getOwner());
            ownable.getOwner().setValidated(true);
            world.func_184138_a(pos, state, state, 3);
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
            SetCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.securitycraft.owner.set.success", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length >= 1 && args.length <= 3) {
                return SetCommand.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
            }
            if (args.length == 4) {
                return SetCommand.func_71530_a((String[])args, (String[])new String[]{"player", "random", "reset"});
            }
            if (this.func_82358_a(args, 4)) {
                return SetCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return args.length == 5 && args[3].equals("player") && index == 4;
        }
    }
}

