/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;

public class HudModHandler {
    protected static final String SHOW_OWNER = "securitycraft.showowner";
    protected static final String SHOW_MODULES = "securitycraft.showmodules";
    protected static final String SHOW_CUSTOM_NAME = "securitycraft.showcustomname";

    protected HudModHandler() {
    }

    public void addDisguisedOwnerModuleNameInfo(World level, BlockPos pos, IBlockState state, Block block, TileEntity be, EntityPlayer player, Consumer<String> lineAdder, Predicate<String> configGetter) {
        IBlockState disguisedState;
        if (be == null) {
            return;
        }
        if (block instanceof IDisguisable && (disguisedState = ((IDisguisable)block).getDisguisedBlockState(be)) != null) {
            block = disguisedState.func_177230_c();
            if (block.hasTileEntity(disguisedState) && !(block instanceof IDisguisable) && block.createTileEntity(level, disguisedState) instanceof IOwnable) {
                this.addOwnerInfo(be, lineAdder, configGetter);
            }
            if (!(block instanceof IOverlayDisplay) || !((IOverlayDisplay)block).shouldShowSCInfo(level, state, pos)) {
                return;
            }
        }
        if (!(block instanceof IBlockMine)) {
            this.addOwnerModuleNameInfo(be, player, lineAdder, configGetter);
        }
    }

    public void addOwnerInfo(Object obj, Consumer<String> lineAdder, Predicate<String> configGetter) {
        if (configGetter.test(SHOW_OWNER) && obj instanceof IOwnable) {
            lineAdder.accept(Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(((IOwnable)obj).getOwner())).func_150254_d());
        }
    }

    public void addOwnerModuleNameInfo(Object obj, EntityPlayer player, Consumer<String> lineAdder, Predicate<String> configGetter) {
        this.addOwnerInfo(obj, lineAdder, configGetter);
        if (configGetter.test(SHOW_MODULES) && obj instanceof IModuleInventory && !((IModuleInventory)obj).getInsertedModules().isEmpty() && (!(obj instanceof IOwnable) || ((IOwnable)obj).isOwnedBy((Entity)player))) {
            IModuleInventory inv = (IModuleInventory)obj;
            lineAdder.accept(Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
            for (ModuleType module : inv.getInsertedModules()) {
                ITextComponent prefix = inv.isModuleEnabled(module) ? new TextComponentString("\u2714 ").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)) : new TextComponentString("\u2715 ").func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                lineAdder.accept(prefix.func_150257_a(new TextComponentTranslation(module.getTranslationKey(), new Object[0]).func_150255_a(Utils.GRAY_STYLE)).func_150254_d());
            }
        }
        if (configGetter.test(SHOW_CUSTOM_NAME) && obj instanceof IWorldNameable && ((IWorldNameable)obj).func_145818_k_()) {
            String name = ((IWorldNameable)obj).func_70005_c_();
            lineAdder.accept(Utils.localize("waila.securitycraft:customName", new Object[0]).func_150254_d() + " " + name);
        }
    }

    public void addEntityInfo(Entity entity, EntityPlayer player, Consumer<String> lineAdder, Predicate<String> configGetter) {
        if (entity instanceof Sentry) {
            Sentry sentry = (Sentry)entity;
            Sentry.SentryMode mode = sentry.getMode();
            this.addOwnerInfo(sentry, lineAdder, configGetter);
            if (configGetter.test(SHOW_MODULES) && sentry.isOwnedBy((Entity)player) && (!sentry.getAllowlistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b() || sentry.hasSpeedModule())) {
                lineAdder.accept(Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
                if (!sentry.getAllowlistModule().func_190926_b()) {
                    lineAdder.accept("- " + Utils.localize(ModuleType.ALLOWLIST.getTranslationKey(), new Object[0]).func_150254_d());
                }
                if (!sentry.getDisguiseModule().func_190926_b()) {
                    lineAdder.accept("- " + Utils.localize(ModuleType.DISGUISE.getTranslationKey(), new Object[0]).func_150254_d());
                }
                if (sentry.hasSpeedModule()) {
                    lineAdder.accept("- " + Utils.localize(ModuleType.SPEED.getTranslationKey(), new Object[0]).func_150254_d());
                }
            }
            String modeDescription = Utils.localize(mode.getModeKey(), new Object[0]).func_150254_d();
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription = modeDescription + " - " + Utils.localize(mode.getTargetKey(), new Object[0]).func_150254_d();
            }
            lineAdder.accept(modeDescription);
        }
    }
}

