/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class UniversalKeyChangerItem
extends Item {
    public EnumActionResult onItemUseFirst(EntityPlayer player, World level, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        EnumActionResult briefcaseResult = this.handleBriefcase(level, player, hand).func_188397_a();
        if (briefcaseResult != EnumActionResult.PASS) {
            return briefcaseResult;
        }
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof DisplayCaseBlockEntity && ((DisplayCaseBlockEntity)te).isOpen() && ((DisplayCaseBlockEntity)te).getDisplayedStack().func_190926_b()) {
            return EnumActionResult.PASS;
        }
        if (te instanceof IPasscodeProtected) {
            if (((IOwnable)te).isOwnedBy((Entity)player)) {
                player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.KEY_CHANGER.ordinal(), level, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
            if (!(te.func_145838_q() instanceof IDisguisable) || ((IDisguisable)te.func_145838_q()).getDisguisedBlockState(te).func_177230_c() instanceof IDisguisable) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalKeyChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner())), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World level, EntityPlayer player, EnumHand hand) {
        return this.handleBriefcase(level, player, hand);
    }

    private ActionResult<ItemStack> handleBriefcase(World level, EntityPlayer player, EnumHand hand) {
        ItemStack keyChanger = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.briefcase) {
            ItemStack briefcase = player.func_184592_cb();
            if (BriefcaseItem.isOwnedBy(briefcase, player) || player.func_184812_l_()) {
                NBTTagCompound tag = briefcase.func_77978_p();
                if (tag != null && tag.func_74764_b("passcode")) {
                    if (tag.func_74764_b("saltKey") && !level.field_72995_K) {
                        SaltData.removeSalt(tag.func_186857_a("saltKey"));
                    }
                    PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), TextFormatting.GREEN);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), TextFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), TextFormatting.RED);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)keyChanger);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)keyChanger);
    }
}

