/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InteractWithFrame
implements IMessage {
    private BlockPos pos;
    private boolean owner;

    public InteractWithFrame() {
    }

    public InteractWithFrame(BlockPos pos, boolean owner) {
        this.pos = pos;
        this.owner = owner;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.owner);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.owner = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<InteractWithFrame, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(InteractWithFrame message, MessageContext context) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                EntityPlayerSP player = mc.field_71439_g;
                World level = player.field_70170_p;
                TileEntity te = level.func_175625_s(message.pos);
                if (te instanceof FrameBlockEntity) {
                    FrameBlockEntity be = (FrameBlockEntity)te;
                    if (!be.redstoneSignalDisabled() && !be.hasClientInteracted() && be.getCurrentCamera() != null) {
                        be.setCurrentCameraAndUpdate(be.getCurrentCamera());
                    } else {
                        ScreenHandler.Screens screen = !message.owner ? ScreenHandler.Screens.FRAME_READ_ONLY : ScreenHandler.Screens.FRAME;
                        mc.func_147108_a((GuiScreen)screen.getClient().apply((EntityPlayer)player, te));
                    }
                }
            });
            return null;
        }
    }
}

