/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CheckPasscode
implements IMessage {
    private String passcode;
    private int x;
    private int y;
    private int z;

    public CheckPasscode() {
    }

    public CheckPasscode(int x, int y, int z, String passcode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.passcode);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.passcode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<CheckPasscode, IMessage> {
        public IMessage onMessage(CheckPasscode message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntity te = player.field_70170_p.func_175625_s(pos);
                if (te instanceof IPasscodeProtected) {
                    IPasscodeProtected be = (IPasscodeProtected)te;
                    if (PasscodeUtils.isOnCooldown((EntityPlayer)player)) {
                        PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passcodeProtected.onCooldown", new Object[0]), TextFormatting.RED);
                        if (ConfigHandler.passcodeSpamLogWarningEnabled) {
                            SecurityCraft.LOGGER.warn(String.format(ConfigHandler.passcodeSpamLogWarning, player.func_146103_bH().getName(), Utils.localize(player.field_70170_p.func_180495_p(pos).func_177230_c(), new Object[0]).func_150261_e(), player.field_70170_p.field_73011_w.func_186058_p() + " " + pos));
                        }
                        return;
                    }
                    if (be.isOnCooldown()) {
                        return;
                    }
                    PasscodeUtils.setOnCooldown((EntityPlayer)player);
                    PasscodeUtils.hashPasscode(message.passcode, be.getSalt(), arg_0 -> Handler.lambda$null$0(be, (EntityPlayer)player, message, arg_0));
                }
            });
            return null;
        }

        private static /* synthetic */ void lambda$null$0(IPasscodeProtected be, EntityPlayer player, CheckPasscode message, byte[] p) {
            if (Arrays.equals(be.getPasscode(), p)) {
                player.func_71053_j();
                be.activate(player);
            } else {
                be.onIncorrectPasscodeEntered(player, message.passcode);
            }
        }
    }
}

