/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetPasscode
implements IMessage {
    private String passcode;
    private int x;
    private int y;
    private int z;

    public SetPasscode() {
    }

    public SetPasscode(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.passcode);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.passcode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<SetPasscode, IMessage> {
        public IMessage onMessage(SetPasscode message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                if (!player.func_175149_v() && te instanceof IPasscodeProtected && (!(te instanceof IOwnable) || ((IOwnable)te).isOwnedBy((Entity)player))) {
                    IPasscodeProtected passcodeProtected = (IPasscodeProtected)te;
                    passcodeProtected.hashAndSetPasscode(message.passcode, arg_0 -> Handler.lambda$null$0(passcodeProtected, (EntityPlayer)player, pos, arg_0));
                    passcodeProtected.setPasscodeInAdjacentBlock(message.passcode);
                }
            });
            return null;
        }

        private static /* synthetic */ void lambda$null$0(IPasscodeProtected passcodeProtected, EntityPlayer player, BlockPos pos, byte[] b) {
            passcodeProtected.openPasscodeGUI(player.field_70170_p, pos, player);
        }
    }
}

