/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncFrame
implements IMessage {
    private BlockPos pos;
    private int requestedRenderDistance;
    private Optional<GlobalPos> removedCamera;
    private Optional<GlobalPos> currentCamera;
    boolean disableCurrentCamera;

    public SyncFrame() {
    }

    public SyncFrame(BlockPos pos, int requestedRenderDistance, Optional<GlobalPos> removedCamera, Optional<GlobalPos> currentCamera, boolean disableCurrentCamera) {
        this.pos = pos;
        this.requestedRenderDistance = requestedRenderDistance;
        this.removedCamera = removedCamera;
        this.currentCamera = currentCamera;
        this.disableCurrentCamera = disableCurrentCamera;
    }

    public void fromBytes(ByteBuf _buf) {
        PacketBuffer buf = new PacketBuffer(_buf);
        this.pos = buf.func_179259_c();
        this.requestedRenderDistance = buf.func_150792_a();
        this.removedCamera = this.readOptional(buf, this::readCameraView);
        this.currentCamera = this.readOptional(buf, this::readCameraView);
        this.disableCurrentCamera = buf.readBoolean();
    }

    public void toBytes(ByteBuf _buf) {
        PacketBuffer buf = new PacketBuffer(_buf);
        buf.func_179255_a(this.pos);
        buf.func_150787_b(this.requestedRenderDistance);
        this.writeOptional(buf, this.removedCamera, this::writeCameraView);
        this.writeOptional(buf, this.currentCamera, this::writeCameraView);
        buf.writeBoolean(this.disableCurrentCamera);
    }

    private <T> Optional<T> readOptional(PacketBuffer buf, Function<PacketBuffer, T> reader) {
        if (buf.readBoolean()) {
            return Optional.of(reader.apply(buf));
        }
        return Optional.empty();
    }

    private GlobalPos readCameraView(PacketBuffer buf) {
        return GlobalPos.of(buf.func_150792_a(), buf.func_179259_c());
    }

    private <T> void writeOptional(PacketBuffer buf, Optional<T> optional, BiConsumer<PacketBuffer, T> writer) {
        if (optional.isPresent()) {
            buf.writeBoolean(true);
            writer.accept(buf, (PacketBuffer)optional.get());
        } else {
            buf.writeBoolean(false);
        }
    }

    private void writeCameraView(PacketBuffer buf, GlobalPos cameraView) {
        buf.func_150787_b(cameraView.dimension());
        buf.func_179255_a(cameraView.pos());
    }

    public static class Handler
    implements IMessageHandler<SyncFrame, IMessage> {
        public IMessage onMessage(SyncFrame message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World level = player.field_70170_p;
                GlobalPos currentCamera = message.currentCamera.orElse(null);
                TileEntity te = level.func_175625_s(message.pos);
                if (!player.func_175149_v() && te instanceof FrameBlockEntity) {
                    FrameBlockEntity be = (FrameBlockEntity)te;
                    if (be.isDisabled()) {
                        return;
                    }
                    boolean isOwner = be.isOwnedBy((Entity)player);
                    if (isOwner) {
                        message.removedCamera.ifPresent(be::removeCamera);
                    }
                    if (isOwner || be.isAllowed((Entity)player)) {
                        be.switchCameras(currentCamera, (EntityPlayer)player, message.requestedRenderDistance, message.disableCurrentCamera);
                    }
                }
            });
            return null;
        }
    }
}

