/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncKeycardSettings
implements IMessage {
    private BlockPos pos;
    private int signature;
    private boolean[] acceptedLevels;
    private boolean link;
    private String usableBy;

    public SyncKeycardSettings() {
    }

    public SyncKeycardSettings(BlockPos pos, boolean[] acceptedLevels, int signature, boolean link, String usableBy) {
        this.pos = pos;
        this.acceptedLevels = acceptedLevels;
        this.signature = signature;
        this.link = link;
        this.usableBy = usableBy;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.signature);
        buf.writeBoolean(this.link);
        for (int i = 0; i < 5; ++i) {
            buf.writeBoolean(this.acceptedLevels[i]);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.usableBy);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.signature = buf.readInt();
        this.link = buf.readBoolean();
        this.acceptedLevels = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            this.acceptedLevels[i] = buf.readBoolean();
        }
        this.usableBy = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<SyncKeycardSettings, IMessage> {
        public IMessage onMessage(SyncKeycardSettings message, MessageContext context) {
            Utils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
                if (!player.func_175149_v() && tile instanceof KeycardReaderBlockEntity) {
                    KeycardReaderBlockEntity te = (KeycardReaderBlockEntity)tile;
                    boolean isOwner = te.isOwnedBy((Entity)player);
                    if (te.isOwnedBy((Entity)player) || te.isAllowed((Entity)player)) {
                        Container container;
                        if (isOwner) {
                            te.setAcceptedLevels(message.acceptedLevels);
                            te.setSignature(message.signature);
                        }
                        if (message.link && (container = player.field_71070_bA) instanceof KeycardReaderMenu) {
                            ((KeycardReaderMenu)container).link(message.usableBy);
                        }
                    }
                }
            });
            return null;
        }
    }
}

