/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.Tooltip;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class CameraSelectScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final String title = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]).func_150254_d();
    private final List<Pair<GlobalPos, String>> cameras;
    protected final boolean readOnly;
    private final ClickButton[] cameraButtons = new ClickButton[10];
    private final CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int page;

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly) {
        this(cameras, readOnly, 1);
    }

    public CameraSelectScreen(List<Pair<GlobalPos, String>> cameras, boolean readOnly, int page) {
        super((Container)new GenericMenu(null));
        this.cameras = cameras;
        this.readOnly = readOnly;
        this.page = page;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ClickButton prevPageButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(-1, this.field_146294_l / 2 - 25, this.field_146295_m / 2 + 57, 20, 20, "<", b -> {
            --this.page;
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }));
        ClickButton nextPageButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(0, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 57, 20, 20, ">", b -> {
            ++this.page;
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }));
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (int i = 0; i < 10; ++i) {
            ClickButton cameraButton;
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.field_147003_i + 18 + i % 5 * 30;
            int y = this.field_147009_r + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            Pair<GlobalPos, String> pair = this.cameras.get(camID - 1);
            GlobalPos view = (GlobalPos)pair.getLeft();
            this.cameraButtons[i] = cameraButton = new ClickButton(buttonId, x, y, 20, 20, "" + camID, button -> this.cameraButtonClicked((ClickButton)((Object)button), camID));
            this.func_189646_b((GuiButton)cameraButton);
            if (!this.readOnly) {
                ((ClickButton)this.func_189646_b((GuiButton)new ClickButton((int)(buttonId + 10), (int)(x + 19), (int)aboveCameraButton, (int)8, (int)8, (String)"x", (Consumer<ClickButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initGui$3(int net.geforcemods.securitycraft.screen.components.ClickButton ), (Lnet/geforcemods/securitycraft/screen/components/ClickButton;)V)((CameraSelectScreen)this, (int)camID)))).field_146124_l = view != null;
            }
            this.redstoneModuleStates[i] = null;
            if (view != null) {
                BlockPos pos = view.pos();
                TileEntity te = world.func_175625_s(pos);
                SecurityCameraBlockEntity cameraBe = te instanceof SecurityCameraBlockEntity ? (SecurityCameraBlockEntity)te : null;
                String cameraName = (String)pair.getRight();
                if (cameraBe != null) {
                    IBlockState state = world.func_180495_p(pos);
                    if (cameraBe.isDisabled() || cameraBe.isShutDown()) {
                        cameraButton.tooltip = new Tooltip((GuiScreen)this, this.field_146289_q, (ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]));
                        cameraButton.field_146124_l = false;
                    } else if (cameraName != null && cameraBe.func_145818_k_()) {
                        cameraName = cameraBe.func_145748_c_().func_150254_d();
                    }
                    this.redstoneModuleStates[i] = state.func_185911_a((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) == 0 ? (!cameraBe.isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (cameraButton.field_146124_l && cameraName != null) {
                    cameraButton.tooltip = new Tooltip((GuiScreen)this, this.field_146289_q, (ITextComponent)Utils.localize("gui.securitycraft:monitor.cameraName", cameraName));
                }
                if (!player.func_184812_l_()) continue;
                ClickButton tpButton = (ClickButton)this.func_189646_b((GuiButton)new ClickButton(buttonId + 20, x, aboveCameraButton, 8, 8, "", b -> {
                    if (player.field_71093_bK == view.dimension()) {
                        player.func_71165_d(String.format("/tp @p %s %s %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    } else {
                        player.func_71165_d(String.format("/forge setdim @p %s %s %s %s", view.dimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    }
                    this.field_146297_k.func_147108_a(null);
                }));
                tpButton.tooltip = new Tooltip((GuiScreen)this, this.field_146289_q, (ITextComponent)Utils.localize("securitycraft.teleport", new Object[0]));
                continue;
            }
            cameraButton.field_146124_l = false;
        }
        prevPageButton.field_146124_l = this.page != 1;
        nextPageButton.field_146124_l = this.page != 3;
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a()) continue;
            button.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < 10; ++i) {
            ClickButton button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render((Gui)this, button.field_146128_h + 4, button.field_146129_i + 25);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void cameraButtonClicked(ClickButton button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            SecurityCameraBlockEntity cameraEntity;
            GlobalPos cameraPos = (GlobalPos)camera.getLeft();
            TileEntity te = this.field_146297_k.field_71441_e.func_175625_s(cameraPos.pos());
            if (te instanceof SecurityCameraBlockEntity && ((cameraEntity = (SecurityCameraBlockEntity)te).isDisabled() || cameraEntity.isShutDown())) {
                button.field_146124_l = false;
                return;
            }
            this.viewCamera(cameraPos);
        }
    }

    protected void viewCamera(GlobalPos cameraPos) {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    private void unbindButtonClicked(ClickButton button, int camID) {
        Pair<GlobalPos, String> camera = this.cameras.get(camID - 1);
        if (camera != null) {
            int i = (camID - 1) % 10;
            ClickButton cameraButton = this.cameraButtons[i];
            this.unbindCamera(camID);
            button.field_146124_l = false;
            cameraButton.field_146124_l = false;
            cameraButton.tooltip = null;
            this.redstoneModuleStates[i] = null;
        }
    }

    protected void unbindCamera(int camID) {
    }

    private /* synthetic */ void lambda$initGui$3(int camID, ClickButton button) {
        this.unbindButtonClicked(button, camID);
    }
}

