/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.BiPredicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockUtils {
    private BlockUtils() {
    }

    public static AxisAlignedBB fromBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d6 = Math.min(x1, x2);
        double d7 = Math.min(y1, y2);
        double d8 = Math.min(z1, z2);
        double d9 = Math.max(x1, x2);
        double d10 = Math.max(y1, y2);
        double d11 = Math.max(z1, z2);
        return new AxisAlignedBB(d6, d7, d8, d9, d10, d11);
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        TileEntity be = world.func_175625_s(pos);
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(world, pos, be, activator));
    }

    private static boolean hasActiveSCBlockNextTo(World world, BlockPos pos, TileEntity te, IDoorActivator activator) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity offsetTe;
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if (activator.getBlocks().contains(offsetState.func_177230_c()) && activator.isPowering(world, offsetPos, offsetState, offsetTe = world.func_175625_s(offsetPos), facing, 1) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te))) {
                return true;
            }
            if (world.func_175651_c(offsetPos, facing) != 15 || offsetState.func_185897_m()) continue;
            for (EnumFacing dirOffset : EnumFacing.values()) {
                TileEntity offsetTe2;
                if (dirOffset.func_176734_d() == facing) continue;
                BlockPos newOffsetPos = offsetPos.func_177972_a(dirOffset);
                offsetState = world.func_180495_p(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.func_177230_c()) || !activator.isPowering(world, newOffsetPos, offsetState, offsetTe2 = world.func_175625_s(newOffsetPos), dirOffset, 2) || offsetTe2 instanceof IOwnable && !((IOwnable)offsetTe2).getOwner().owns((IOwnable)te)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends TileEntity> boolean isAllowedToExtractFromProtectedObject(EnumFacing side, T be) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, (IOwnable)be, be.func_145831_w(), be.func_174877_v());
    }

    public static boolean isAllowedToExtractFromProtectedObject(EnumFacing side, IOwnable ownable, World level, BlockPos pos) {
        if (side != null && level != null) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState offsetState = level.func_180495_p(offsetPos);
            for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
                if (offsetState.func_177230_c() != extractionBlock.getBlock()) continue;
                return extractionBlock.canExtract(ownable, level, offsetPos, offsetState);
            }
        }
        return false;
    }

    public static boolean isInsideUnownedReinforcedBlocks(World level, EntityPlayer player, double yHeight) {
        BlockPos.PooledMutableBlockPos testPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            TileEntity be;
            int x = MathHelper.func_76128_c((double)(player.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * player.field_70130_N * 0.8f)));
            int y = MathHelper.func_76128_c((double)(player.field_70163_u + (double)(((float)(i % 2) - 0.5f) * 0.1f) + yHeight));
            int z = MathHelper.func_76128_c((double)(player.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * player.field_70130_N * 0.8f)));
            if (testPos.func_177958_n() == x && testPos.func_177956_o() == y && testPos.func_177952_p() == z) continue;
            testPos.func_181079_c(x, y, z);
            IBlockState state = level.func_180495_p((BlockPos)testPos);
            if (!(state.func_177230_c() instanceof IReinforcedBlock) || !state.func_191058_s() || (be = level.func_175625_s((BlockPos)testPos)) instanceof IOwnable && ((IOwnable)be).isOwnedBy((Entity)player)) continue;
            testPos.func_185344_t();
            return true;
        }
        testPos.func_185344_t();
        return false;
    }

    public static boolean isWithinUsableDistance(World world, BlockPos pos, EntityPlayer player, Block block) {
        return world.func_180495_p(pos).func_177230_c() == block && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public static void updateIndirectNeighbors(World world, BlockPos pos, Block block) {
        BlockUtils.updateIndirectNeighbors(world, pos, block, EnumFacing.values());
    }

    public static void updateIndirectNeighbors(World world, BlockPos pos, Block block, EnumFacing ... directions) {
        world.func_175685_c(pos, block, false);
        for (EnumFacing dir : directions) {
            world.func_175685_c(pos.func_177972_a(dir), block, false);
        }
    }

    public static void removeInSequence(BiPredicate<EnumFacing, IBlockState> stateMatcher, World world, BlockPos pos, EnumFacing ... directions) {
        for (EnumFacing direction : directions) {
            int i = 1;
            BlockPos modifiedPos = pos.func_177967_a(direction, i);
            while (stateMatcher.test(direction, world.func_180495_p(modifiedPos))) {
                world.func_175698_g(modifiedPos);
                modifiedPos = pos.func_177967_a(direction, ++i);
            }
        }
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress(destroyProgress, state, player, level, pos, false);
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, IBlockState state, EntityPlayer player, World level, BlockPos pos, boolean allowDefault) {
        if (state.func_177230_c() instanceof IBlockMine) {
            return destroyProgress.get(state, player, level, pos);
        }
        if (ConfigHandler.vanillaToolBlockBreaking) {
            TileEntity be = level.func_175625_s(pos);
            if (be instanceof IOwnable && ((IOwnable)be).isOwnedBy((Entity)player)) {
                return destroyProgress.get(state, player, level, pos);
            }
            if (ConfigHandler.allowBreakingNonOwnedBlocks || allowDefault && be instanceof IOwnable && ((IOwnable)be).getOwner().equals(new Owner())) {
                return (float)((double)destroyProgress.get(state, player, level, pos) / ConfigHandler.nonOwnedBreakingSlowdown);
            }
        }
        return 0.0f;
    }

    @FunctionalInterface
    public static interface DestroyProgress {
        public float get(IBlockState var1, EntityPlayer var2, World var3, BlockPos var4);
    }
}

