/*
 * Decompiled with CFR 0.152.
 */
package rivoreo.minecraft.aggressivechickens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import rivoreo.minecraft.aggressivechickens.AngryWhenBeingStaredByPlayerTask;
import rivoreo.minecraft.aggressivechickens.ForceMeleeAttackTask;

@Mod(modid="aggressive-chickens", version="1.7", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.10,1.13)", useMetadata=true)
public class ForgeMod {
    public static final String MODID = "aggressive-chickens";
    public static final String VERSION = "1.7";
    private Configuration config;
    private boolean hurted_chicken_call_for_help;
    private double call_help_max_distance;
    private int attack_damage;
    private boolean revenge_for_killed_chicken;
    private double revenge_for_killed_chicken_horizontal_distance;
    private double revenge_for_killed_chicken_vertical_distance;
    private boolean angry_when_being_stared_by_player;
    private double angry_when_being_stared_by_player_max_distance;
    private double attack_moving_speed;
    private int use_attack_damage_attribute;

    @Mod.EventHandler
    public void pre_init(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.hurted_chicken_call_for_help = this.config.getBoolean("HurtedChickenCallForHelp", MODID, true, "Being attacked chicken call nearby chickens for help");
        Property prop = this.config.get(MODID, "CallHelpMaxDistance", Double.NaN, "Maximum horizontal distance for a chicken to help a being attacked chicken [Set to NaN to keep Minecraft default FOLLOW_RANGE attribute, this is default]");
        this.call_help_max_distance = prop.getDouble();
        if (!Double.isNaN(this.call_help_max_distance)) {
            if (this.call_help_max_distance < 1.0) {
                this.call_help_max_distance = 1.0;
            } else if (this.call_help_max_distance > 2048.0) {
                this.call_help_max_distance = 2048.0;
            }
        }
        this.attack_damage = this.config.getInt("AttackDamage", MODID, 2, 1, 20, "Chicken's attack damage");
        this.revenge_for_killed_chicken = this.config.getBoolean("RevengeForKilledChicken", MODID, true, "Nearby chickens will start retaliation if they witnessed another chicken being killed by someone");
        prop = this.config.get(MODID, "RevengeForKilledChickenHorizontalDistance", 16.0, "Provoke chickens in this horizontal radius range to revenge for killed chicken, if RevengeForKilledChicken is enabled [range: 1 ~ 128, default: 16]", 1.0, 128.0);
        this.revenge_for_killed_chicken_horizontal_distance = prop.getDouble();
        prop = this.config.get(MODID, "RevengeForKilledChickenVerticalDistance", 12.0, "Provoke chickens in this vertical radius range to revenge for killed chicken, if RevengeForKilledChicken is enabled [range: 1 ~ 128, default: 12]", 1.0, 128.0);
        this.revenge_for_killed_chicken_vertical_distance = prop.getDouble();
        this.angry_when_being_stared_by_player = this.config.getBoolean("AngryWhenBeingStaredByPlayer", MODID, false, "Chicken will get angry when being stared by nearest player");
        prop = this.config.get(MODID, "AngryWhenBeingStaredByPlayerMaxDistance", 16.0, "Maximum distance for provoking the chicken when a player staring on it [range: 1 ~ 64, default: 16]", 1.0, 64.0);
        this.angry_when_being_stared_by_player_max_distance = prop.getDouble();
        prop = this.config.get(MODID, "AttackMovingSpeed", 0.9, "Chicken's moving speed towards to target when attacking [range: 0.25 ~ 2, default: 0.9]", 0.25, 2.0);
        this.attack_moving_speed = prop.getDouble();
        prop = this.config.get(MODID, "UseAttackDamageAttribute", 1, "Whether to use the ATTACK_DAMAGE entity attribute [0: Don't use at all, 1: Use if present, 2: Similar to '1', but also add the attribute to chickens if not present, 3: Similar to '2', but also reset value for existing attributes, default: 1]", 0, 3);
        this.use_attack_damage_attribute = prop.getInt();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void on_entity_join_world(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityChicken)) {
            return;
        }
        EntityChicken chicken = (EntityChicken)event.getEntity();
        if (chicken.field_70170_p.field_72995_K) {
            return;
        }
        AbstractAttributeMap attrib_map = chicken.func_110140_aT();
        if (this.use_attack_damage_attribute >= 2) {
            IAttributeInstance attack_damage_attrib = attrib_map.func_111151_a(SharedMonsterAttributes.field_111264_e);
            if (attack_damage_attrib == null) {
                attack_damage_attrib = attrib_map.func_111150_b(SharedMonsterAttributes.field_111264_e);
                attack_damage_attrib.func_111128_a((double)this.attack_damage);
            } else if (this.use_attack_damage_attribute == 3) {
                attack_damage_attrib.func_111128_a((double)this.attack_damage);
            }
        }
        if (this.hurted_chicken_call_for_help && !Double.isNaN(this.call_help_max_distance)) {
            attrib_map.func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.call_help_max_distance);
        }
        ArrayList<EntityAIBase> tasks_to_remove = new ArrayList<EntityAIBase>();
        for (EntityAITasks.EntityAITaskEntry e : chicken.field_70714_bg.field_75782_a) {
            EntityAIBase task = e.field_75733_a;
            if (this.angry_when_being_stared_by_player && task instanceof EntityAITempt) {
                tasks_to_remove.add(task);
                continue;
            }
            if (!(task instanceof EntityAIPanic)) continue;
            tasks_to_remove.add(task);
        }
        for (EntityAIBase task : tasks_to_remove) {
            chicken.field_70714_bg.func_85156_a(task);
        }
        chicken.field_70714_bg.func_75776_a(1, (EntityAIBase)new ForceMeleeAttackTask((EntityCreature)chicken, this.attack_moving_speed, this.attack_damage, this.use_attack_damage_attribute > 0, true));
        chicken.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)chicken, this.hurted_chicken_call_for_help, new Class[0]));
        if (this.angry_when_being_stared_by_player) {
            chicken.field_70714_bg.func_75776_a(3, (EntityAIBase)new AngryWhenBeingStaredByPlayerTask((EntityCreature)chicken, this.angry_when_being_stared_by_player_max_distance));
        }
    }

    @SubscribeEvent
    public void on_living_entity_death(LivingDeathEvent event) {
        Entity killer = event.getSource().func_76346_g();
        if (killer == null) {
            return;
        }
        if (killer.field_70170_p.field_72995_K) {
            return;
        }
        if (killer instanceof EntityChicken) {
            ((EntityChicken)killer).func_70624_b(null);
            return;
        }
        if (!this.revenge_for_killed_chicken) {
            return;
        }
        if (!(event.getEntity() instanceof EntityChicken)) {
            return;
        }
        if (!(killer instanceof EntityLivingBase)) {
            return;
        }
        EntityChicken died_chicken = (EntityChicken)event.getEntity();
        double x = died_chicken.field_70165_t;
        double y = died_chicken.field_70163_u;
        double z = died_chicken.field_70161_v;
        List nearby_chickens = died_chicken.field_70170_p.func_72872_a(EntityChicken.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(this.revenge_for_killed_chicken_horizontal_distance, this.revenge_for_killed_chicken_vertical_distance, this.revenge_for_killed_chicken_horizontal_distance));
        for (EntityChicken chicken : nearby_chickens) {
            EntityLivingBase current_attack_target;
            if (chicken == died_chicken || (current_attack_target = chicken.func_70638_az()) != null && current_attack_target.func_70089_S()) continue;
            chicken.func_70624_b((EntityLivingBase)killer);
        }
    }
}

