# Rolldoor Controller

[YouTube Video which shows how to setup a rolldoor](https://www.youtube.com/watch?v=ab-SApBGlY4)

![](https://i.imgur.com/Yz8te4J.png)

Recipe:
* 3x Nether Quartz
* 2x Microchip Tier2
* 2x Transistor
* 1x Control Unit (CU)
* 1x Cable

Is used to control [Rolldoor](Rolldoor)

### Notes
The rolldoor controller can be camouflaged by right clicking it with a valid solid block
The color of the rolldoor can be changed by right clicking the controller with any dye

## Methods
passwords argument is only required if a password was set
```lua
getHeight():integer -- returns the height/end position of the door
getPosition():double -- returns the current position of the door
close([String:password]):boolean -- moves the door to end position
open([String:password]):boolean -- moves the door to position 0
toggle([String:password]):boolean -- toggles the door (closes if its at position 0, opens otherwise)
isMoving():boolean -- guess it
setPosition(double:targetPosition[, String:password]):double -- moves the door to the provided position [range: 0 - height]
setSpeed(double:moveSpeed[, String:password]):double -- sets the move speed of the rolldoor, returns the new speed value [range: 0.1 - 3]
setPassword(String:newPassword[, String:oldPassword]):boolean -- sets/resets the rolldoor password
```

