/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.beans.BeansLinker;
import jdk.internal.dynalink.linker.ConversionComparator;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.GuardingDynamicLinker;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.Guards;
import jdk.internal.dynalink.support.Lookup;
import jdk.nashorn.api.scripting.ScriptUtils;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.options.Options;

public class NashornBeansLinker
implements GuardingDynamicLinker {
    private static final boolean MIRROR_ALWAYS = Options.getBooleanProperty("nashorn.mirror.always", true);
    private static final MethodHandle EXPORT_ARGUMENT;
    private static final MethodHandle EXPORT_NATIVE_ARRAY;
    private static final MethodHandle EXPORT_SCRIPT_OBJECT;
    private static final MethodHandle IMPORT_RESULT;
    private static final MethodHandle FILTER_CONSSTRING;
    private static final ClassValue<Method> FUNCTIONAL_IFACE_METHOD;
    private final BeansLinker beansLinker = new BeansLinker();

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Method m;
        Object self = linkRequest.getReceiver();
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (self instanceof ConsString) {
            Object[] arguments = linkRequest.getArguments();
            arguments[0] = "";
            LinkRequest forgedLinkRequest = linkRequest.replaceArguments(desc, arguments);
            GuardedInvocation invocation = NashornBeansLinker.getGuardedInvocation(this.beansLinker, forgedLinkRequest, linkerServices);
            return invocation == null ? null : invocation.filterArguments(0, FILTER_CONSSTRING);
        }
        if (self != null && "call".equals(desc.getNameToken(1)) && (m = NashornBeansLinker.getFunctionalInterfaceMethod(self.getClass())) != null) {
            MethodType callType = desc.getMethodType();
            if (callType.parameterCount() != m.getParameterCount() + 2) {
                throw ECMAErrors.typeError("no.method.matches.args", ScriptRuntime.safeToString(self));
            }
            return new GuardedInvocation(jdk.nashorn.internal.lookup.Lookup.MH.dropArguments(desc.getLookup().unreflect(m), 1, new Class[]{callType.parameterType(1)}), Guards.getInstanceOfGuard(m.getDeclaringClass())).asTypeSafeReturn(new NashornBeansLinkerServices(linkerServices), callType);
        }
        return NashornBeansLinker.getGuardedInvocation(this.beansLinker, linkRequest, linkerServices);
    }

    public static GuardedInvocation getGuardedInvocation(GuardingDynamicLinker delegateLinker, LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        return delegateLinker.getGuardedInvocation(linkRequest, new NashornBeansLinkerServices(linkerServices));
    }

    private static Object exportArgument(Object arg) {
        return NashornBeansLinker.exportArgument(arg, MIRROR_ALWAYS);
    }

    private static Object exportNativeArray(NativeArray arg) {
        return NashornBeansLinker.exportArgument(arg, MIRROR_ALWAYS);
    }

    private static Object exportScriptObject(ScriptObject arg) {
        return NashornBeansLinker.exportArgument(arg, MIRROR_ALWAYS);
    }

    private static Object exportScriptArray(NativeArray arg) {
        return NashornBeansLinker.exportArgument(arg, MIRROR_ALWAYS);
    }

    static Object exportArgument(Object arg, boolean mirrorAlways) {
        if (arg instanceof ConsString) {
            return arg.toString();
        }
        if (mirrorAlways && arg instanceof ScriptObject) {
            return ScriptUtils.wrap((ScriptObject)arg);
        }
        return arg;
    }

    private static Object importResult(Object arg) {
        return ScriptUtils.unwrap(arg);
    }

    private static Object consStringFilter(Object arg) {
        return arg instanceof ConsString ? arg.toString() : arg;
    }

    private static Method findFunctionalInterfaceMethod(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!Context.isAccessibleClass(iface) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
            for (Method m : iface.getMethods()) {
                if (!Modifier.isAbstract(m.getModifiers())) continue;
                return m;
            }
        }
        return NashornBeansLinker.findFunctionalInterfaceMethod(clazz.getSuperclass());
    }

    static Method getFunctionalInterfaceMethod(Class<?> clazz) {
        return FUNCTIONAL_IFACE_METHOD.get(clazz);
    }

    static {
        Lookup lookup = new Lookup(MethodHandles.lookup());
        EXPORT_ARGUMENT = lookup.findOwnStatic("exportArgument", Object.class, Object.class);
        EXPORT_NATIVE_ARRAY = lookup.findOwnStatic("exportNativeArray", Object.class, NativeArray.class);
        EXPORT_SCRIPT_OBJECT = lookup.findOwnStatic("exportScriptObject", Object.class, ScriptObject.class);
        IMPORT_RESULT = lookup.findOwnStatic("importResult", Object.class, Object.class);
        FILTER_CONSSTRING = lookup.findOwnStatic("consStringFilter", Object.class, Object.class);
        FUNCTIONAL_IFACE_METHOD = new ClassValue<Method>(){

            @Override
            protected Method computeValue(Class<?> type) {
                return NashornBeansLinker.findFunctionalInterfaceMethod(type);
            }
        };
    }

    private static class NashornBeansLinkerServices
    implements LinkerServices {
        private final LinkerServices linkerServices;

        NashornBeansLinkerServices(LinkerServices linkerServices) {
            this.linkerServices = linkerServices;
        }

        @Override
        public MethodHandle asType(MethodHandle handle, MethodType fromType) {
            MethodHandle result;
            MethodType handleType = handle.type();
            int paramCount = handleType.parameterCount();
            assert (fromType.parameterCount() == handleType.parameterCount());
            MethodType newFromType = fromType;
            MethodHandle[] filters = null;
            for (int i = 0; i < paramCount; ++i) {
                MethodHandle filter = NashornBeansLinkerServices.argConversionFilter(handleType.parameterType(i), fromType.parameterType(i));
                if (filter == null) continue;
                if (filters == null) {
                    filters = new MethodHandle[paramCount];
                }
                newFromType = newFromType.changeParameterType(i, Object.class);
                filters[i] = filter;
            }
            MethodHandle typed = this.linkerServices.asType(handle, newFromType);
            MethodHandle methodHandle = result = filters != null ? MethodHandles.filterArguments(typed, 0, filters) : typed;
            if (MIRROR_ALWAYS && NashornBeansLinkerServices.areBothObjects(handleType.returnType(), fromType.returnType())) {
                result = MethodHandles.filterReturnValue(result, IMPORT_RESULT);
            }
            return result;
        }

        private static MethodHandle argConversionFilter(Class<?> handleType, Class<?> fromType) {
            if (handleType == Object.class) {
                if (fromType == Object.class) {
                    return EXPORT_ARGUMENT;
                }
                if (fromType == NativeArray.class) {
                    return EXPORT_NATIVE_ARRAY;
                }
                if (fromType == ScriptObject.class) {
                    return EXPORT_SCRIPT_OBJECT;
                }
            }
            return null;
        }

        private static boolean areBothObjects(Class<?> handleType, Class<?> fromType) {
            return handleType == Object.class && fromType == Object.class;
        }

        @Override
        public MethodHandle asTypeLosslessReturn(MethodHandle handle, MethodType fromType) {
            return LinkerServices.Implementation.asTypeLosslessReturn(this, handle, fromType);
        }

        @Override
        public MethodHandle getTypeConverter(Class<?> sourceType, Class<?> targetType) {
            return this.linkerServices.getTypeConverter(sourceType, targetType);
        }

        @Override
        public boolean canConvert(Class<?> from, Class<?> to) {
            return this.linkerServices.canConvert(from, to);
        }

        @Override
        public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest) throws Exception {
            return this.linkerServices.getGuardedInvocation(linkRequest);
        }

        @Override
        public ConversionComparator.Comparison compareConversion(Class<?> sourceType, Class<?> targetType1, Class<?> targetType2) {
            if (sourceType == ConsString.class) {
                if (String.class == targetType1 || CharSequence.class == targetType1) {
                    return ConversionComparator.Comparison.TYPE_1_BETTER;
                }
                if (String.class == targetType2 || CharSequence.class == targetType2) {
                    return ConversionComparator.Comparison.TYPE_2_BETTER;
                }
            }
            return this.linkerServices.compareConversion(sourceType, targetType1, targetType2);
        }
    }
}

