/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.data;

import erogenousbeef.bigreactors.common.BRLog;
import net.minecraft.nbt.NBTTagCompound;

public class ReactantStack {
    private String reactant;
    public int amount;

    public ReactantStack(String name, int amount) {
        assert (name != null);
        this.reactant = name;
        this.amount = amount;
    }

    public ReactantStack(String name) {
        assert (name != null);
        this.reactant = name;
        this.amount = 0;
    }

    public static ReactantStack createFromNBT(NBTTagCompound tag) {
        String name = null;
        int amount = 0;
        if (!tag.func_74764_b("name")) {
            return null;
        }
        name = tag.func_74779_i("name");
        if (tag.func_74764_b("amount")) {
            amount = tag.func_74762_e("amount");
        }
        return new ReactantStack(name, amount);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("name")) {
            this.reactant = tag.func_74779_i("name");
        } else {
            BRLog.warning("ReactantStack::readFromNBT - Received a tag with no name!", new Object[0]);
        }
        if (tag.func_74764_b("amount")) {
            this.amount = tag.func_74762_e("amount");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.reactant);
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    public boolean isReactantEqual(String name) {
        return this.reactant.equals(name);
    }

    public boolean isReactantEqual(ReactantStack other) {
        return this.reactant.equals(other.reactant);
    }

    public String getName() {
        return this.reactant;
    }

    public ReactantStack split(int desiredAmount) {
        if (desiredAmount <= 0) {
            throw new IllegalArgumentException("Cannot split a reactant into a stack of size zero");
        }
        if (desiredAmount >= this.amount) {
            return this;
        }
        ReactantStack newStack = new ReactantStack(this.reactant, desiredAmount);
        this.amount -= desiredAmount;
        return newStack;
    }

    public String toString() {
        if (this.reactant == null) {
            return "UNKNOWN";
        }
        return String.format("%s, %d mB", this.reactant, this.amount);
    }
}

