/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderStateConfiguration {
    private final List<RenderStateEntry> renderStateEntries;

    public static Builder builder() {
        return new Builder();
    }

    private RenderStateConfiguration(List<RenderStateEntry> renderStateEntries) {
        this.renderStateEntries = renderStateEntries;
    }

    public void setup() {
        this.renderStateEntries.forEach(RenderStateEntry::setup);
    }

    public void clear() {
        this.renderStateEntries.forEach(RenderStateEntry::clear);
    }

    public static class RenderStateEntry {
        private final Runnable setup;
        private final Runnable clear;

        public RenderStateEntry(Runnable setup, Runnable clear) {
            this.setup = setup == null ? () -> {} : setup;
            this.clear = clear == null ? () -> {} : clear;
        }

        public void setup() {
            this.setup.run();
        }

        public void clear() {
            this.clear.run();
        }
    }

    public static class Builder {
        private RenderStateEntry textureState;
        private RenderStateEntry transparencyState;
        private RenderStateEntry depthTestState;
        private RenderStateEntry cullingState;
        private RenderStateEntry lightmapState;
        private RenderStateEntry layeringState;
        private RenderStateEntry depthMaskState;
        private RenderStateEntry colorMaskState;
        private RenderStateEntry lineWidthState;
        private RenderStateEntry lightingState;
        private final List<RenderStateEntry> entries = new ArrayList<RenderStateEntry>();

        private Builder() {
            this.disableTexture();
            this.disableTransparency();
            this.useLessThanOrEqualDepthTest();
            this.enableCulling();
            this.disableLightmap();
            this.disableOverlay();
            this.disableLayering();
            this.enableDepthMask();
            this.enableColorMask();
            this.useDefaultLineWidth();
            this.enableLighting();
        }

        public Builder append(RenderStateEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder disableTexture() {
            this.textureState = new RenderStateEntry(null, null){
                private boolean enableTextures;

                @Override
                public void setup() {
                    this.enableTextures = GL11.glIsEnabled((int)3553);
                    GlStateManager.func_179090_x();
                }

                @Override
                public void clear() {
                    if (this.enableTextures) {
                        GlStateManager.func_179098_w();
                    }
                }
            };
            return this;
        }

        public Builder useTexture(final ResourceLocation texture, final boolean useBlur, final boolean useMipmap) {
            this.textureState = new RenderStateEntry(null, null){
                private boolean enableTextures;

                @Override
                public void setup() {
                    this.enableTextures = GL11.glIsEnabled((int)3553);
                    GlStateManager.func_179098_w();
                    ClientUtils.getTextureManager().func_110577_a(texture);
                    ClientUtils.getTextureManager().func_110581_b(texture).func_174936_b(useBlur, useMipmap);
                }

                @Override
                public void clear() {
                    if (!this.enableTextures) {
                        GlStateManager.func_179090_x();
                    }
                    ClientUtils.getTextureManager().func_110581_b(texture).func_174935_a();
                }
            };
            return this;
        }

        public Builder disableTransparency() {
            this.transparencyState = new RenderStateEntry(null, null){
                private boolean enableBlend;

                @Override
                public void setup() {
                    this.enableBlend = GL11.glIsEnabled((int)3042);
                    GlStateManager.func_179084_k();
                }

                @Override
                public void clear() {
                    if (this.enableBlend) {
                        GlStateManager.func_179147_l();
                    }
                }
            };
            return this;
        }

        public Builder useAdditiveTransparency() {
            this.transparencyState = new RenderStateEntry(null, null){
                private boolean enableBlend;

                @Override
                public void setup() {
                    this.enableBlend = GL11.glIsEnabled((int)3042);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                }

                @Override
                public void clear() {
                    if (!this.enableBlend) {
                        GlStateManager.func_179084_k();
                        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    }
                }
            };
            return this;
        }

        public Builder useTranslucentTransparency() {
            this.transparencyState = new RenderStateEntry(null, null){
                private boolean enableBlend;

                @Override
                public void setup() {
                    this.enableBlend = GL11.glIsEnabled((int)3042);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }

                @Override
                public void clear() {
                    if (!this.enableBlend) {
                        GlStateManager.func_179084_k();
                        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    }
                }
            };
            return this;
        }

        public Builder disableDepthTest() {
            this.depthTestState = new RenderStateEntry(null, null){
                private boolean enableDepthTest;

                @Override
                public void setup() {
                    this.enableDepthTest = GL11.glIsEnabled((int)2929);
                    GlStateManager.func_179097_i();
                }

                @Override
                public void clear() {
                    if (this.enableDepthTest) {
                        GlStateManager.func_179126_j();
                    }
                }
            };
            return this;
        }

        public Builder useEqualDepthTest() {
            this.depthTestState = new RenderStateEntry(null, null){
                private boolean enableDepthTest;

                @Override
                public void setup() {
                    this.enableDepthTest = GL11.glIsEnabled((int)2929);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179143_c((int)514);
                }

                @Override
                public void clear() {
                    if (!this.enableDepthTest) {
                        GlStateManager.func_179097_i();
                    }
                    GlStateManager.func_179143_c((int)515);
                }
            };
            return this;
        }

        public Builder useLessThanOrEqualDepthTest() {
            this.depthTestState = new RenderStateEntry(null, null){
                private boolean enableDepthTest;

                @Override
                public void setup() {
                    this.enableDepthTest = GL11.glIsEnabled((int)2929);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179143_c((int)515);
                }

                @Override
                public void clear() {
                    if (!this.enableDepthTest) {
                        GlStateManager.func_179097_i();
                    }
                }
            };
            return this;
        }

        public Builder disableCulling() {
            this.cullingState = new RenderStateEntry(null, null){
                private boolean enableCulling;

                @Override
                public void setup() {
                    this.enableCulling = GL11.glIsEnabled((int)2884);
                    GlStateManager.func_179129_p();
                }

                @Override
                public void clear() {
                    if (this.enableCulling) {
                        GlStateManager.func_179089_o();
                    }
                }
            };
            return this;
        }

        public Builder enableCulling() {
            this.cullingState = new RenderStateEntry(null, null){
                private boolean enableCulling;

                @Override
                public void setup() {
                    this.enableCulling = GL11.glIsEnabled((int)2884);
                    GlStateManager.func_179089_o();
                }

                @Override
                public void clear() {
                    if (!this.enableCulling) {
                        GlStateManager.func_179129_p();
                    }
                }
            };
            return this;
        }

        public Builder disableLightmap() {
            this.lightmapState = new RenderStateEntry(null, null){
                private boolean enableLightmap;

                @Override
                public void setup() {
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                    this.enableLightmap = GL11.glIsEnabled((int)3553);
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    ClientUtils.getMinecraft().field_71460_t.func_175072_h();
                }

                @Override
                public void clear() {
                    if (this.enableLightmap) {
                        ClientUtils.getMinecraft().field_71460_t.func_180436_i();
                    }
                }
            };
            return this;
        }

        public Builder enableLightmap() {
            this.lightmapState = new RenderStateEntry(null, null){
                private boolean enableLightmap;

                @Override
                public void setup() {
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                    this.enableLightmap = GL11.glIsEnabled((int)3553);
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    ClientUtils.getMinecraft().field_71460_t.func_180436_i();
                }

                @Override
                public void clear() {
                    if (!this.enableLightmap) {
                        ClientUtils.getMinecraft().field_71460_t.func_175072_h();
                    }
                }
            };
            return this;
        }

        public Builder disableOverlay() {
            return this;
        }

        public Builder enableOverlay() {
            return this;
        }

        public Builder disableLayering() {
            this.layeringState = new RenderStateEntry(null, null){
                private boolean enablePolygonOffset;

                @Override
                public void setup() {
                    this.enablePolygonOffset = GL11.glIsEnabled((int)32823);
                    GlStateManager.func_179113_r();
                }

                @Override
                public void clear() {
                    if (this.enablePolygonOffset) {
                        GlStateManager.func_179088_q();
                    }
                }
            };
            return this;
        }

        public Builder usePolygonOffsetLayering() {
            this.layeringState = new RenderStateEntry(null, null){
                private boolean enablePolygonOffset;

                @Override
                public void setup() {
                    this.enablePolygonOffset = GL11.glIsEnabled((int)32823);
                    GlStateManager.func_179136_a((float)-1.0f, (float)-10.0f);
                    GlStateManager.func_179088_q();
                }

                @Override
                public void clear() {
                    if (!this.enablePolygonOffset) {
                        GlStateManager.func_179113_r();
                    }
                    GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                }
            };
            return this;
        }

        public Builder useViewOffsetZLayering() {
            this.layeringState = new RenderStateEntry(() -> {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.99975586f, (float)0.99975586f, (float)0.99975586f);
            }, GlStateManager::func_179121_F);
            return this;
        }

        public Builder disableDepthMask() {
            this.depthMaskState = new RenderStateEntry(() -> GlStateManager.func_179132_a((boolean)false), () -> GlStateManager.func_179132_a((boolean)true));
            return this;
        }

        public Builder enableDepthMask() {
            this.depthMaskState = new RenderStateEntry(() -> GlStateManager.func_179132_a((boolean)true), null);
            return this;
        }

        public Builder disableColorMask() {
            this.colorMaskState = new RenderStateEntry(null, null){

                @Override
                public void setup() {
                    GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                }

                @Override
                public void clear() {
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
            };
            return this;
        }

        public Builder enableColorMask() {
            this.colorMaskState = new RenderStateEntry(() -> GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true), null);
            return this;
        }

        public Builder useColorMask(boolean writeRed, boolean writeGreen, boolean writeBlue, boolean writeAlpha) {
            this.colorMaskState = new RenderStateEntry(() -> GlStateManager.func_179135_a((boolean)writeRed, (boolean)writeGreen, (boolean)writeBlue, (boolean)writeAlpha), () -> GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true));
            return this;
        }

        public Builder useDefaultLineWidth() {
            this.lineWidthState = new RenderStateEntry(() -> GlStateManager.func_187441_d((float)1.0f), null);
            return this;
        }

        public Builder useLineWidth(float width) {
            this.lineWidthState = new RenderStateEntry(() -> GlStateManager.func_187441_d((float)width), () -> GlStateManager.func_187441_d((float)1.0f));
            return this;
        }

        public Builder useWindowRelativeLineWidth() {
            this.lineWidthState = new RenderStateEntry(() -> GlStateManager.func_187441_d((float)Math.max(2.5f, (float)ClientUtils.getMinecraft().field_71443_c / 1920.0f * 2.5f)), () -> GlStateManager.func_187441_d((float)1.0f));
            return this;
        }

        public Builder disableLighting() {
            this.lightingState = new RenderStateEntry(null, null){
                private boolean enableLighting;

                @Override
                public void setup() {
                    this.enableLighting = GL11.glIsEnabled((int)2896);
                    GlStateManager.func_179140_f();
                }

                @Override
                public void clear() {
                    if (this.enableLighting) {
                        GlStateManager.func_179145_e();
                    }
                }
            };
            return this;
        }

        public Builder enableLighting() {
            this.lightingState = new RenderStateEntry(null, null){
                private boolean enableLighting;

                @Override
                public void setup() {
                    this.enableLighting = GL11.glIsEnabled((int)2896);
                    GlStateManager.func_179145_e();
                }

                @Override
                public void clear() {
                    if (!this.enableLighting) {
                        GlStateManager.func_179140_f();
                    }
                }
            };
            return this;
        }

        public RenderStateConfiguration build() {
            ArrayList<RenderStateEntry> combinedEntries = new ArrayList<RenderStateEntry>(11 + this.entries.size());
            combinedEntries.add(this.textureState);
            combinedEntries.add(this.transparencyState);
            combinedEntries.add(this.depthTestState);
            combinedEntries.add(this.cullingState);
            combinedEntries.add(this.lightmapState);
            combinedEntries.add(this.layeringState);
            combinedEntries.add(this.depthMaskState);
            combinedEntries.add(this.colorMaskState);
            combinedEntries.add(this.lineWidthState);
            combinedEntries.add(this.lightingState);
            combinedEntries.addAll(this.entries);
            return new RenderStateConfiguration(combinedEntries);
        }
    }
}

