/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.Validate;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;

public class PacketWrapper
implements IMessage {
    INetworkPacket packet;

    public PacketWrapper(INetworkPacket packet) {
        this.packet = packet;
    }

    public PacketWrapper() {
    }

    public void fromBytes(ByteBuf buf) {
        try {
            ExtendedPacketBuffer packetBuffer = new ExtendedPacketBuffer(buf);
            String name = packetBuffer.func_150789_c(packetBuffer.readInt());
            this.packet = (INetworkPacket)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        try {
            this.packet.readData(new ExtendedPacketBuffer(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        Validate.notNull((Object)this.packet);
        ExtendedPacketBuffer packetBuffer = new ExtendedPacketBuffer(buf);
        packetBuffer.writeInt(this.packet.getClass().getCanonicalName().length());
        packetBuffer.func_180714_a(this.packet.getClass().getCanonicalName());
        try {
            this.packet.writeData(new ExtendedPacketBuffer(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PacketWrapperHandler
    implements IMessageHandler<PacketWrapper, IMessage> {
        public IMessage onMessage(PacketWrapper message, MessageContext ctx) {
            message.packet.processData(message.packet, ctx);
            return null;
        }
    }
}

