/*
 * Decompiled with CFR 0.152.
 */
package kethas.railsplus.proxy;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import kethas.railsplus.BlastFurnaceRecipe;
import kethas.railsplus.RailsPlus;
import kethas.railsplus.RailsPlusConfig;
import kethas.railsplus.RailsPlusGuiHandler;
import kethas.railsplus.block.BlockBlastFurnace;
import kethas.railsplus.item.ItemCoke;
import kethas.railsplus.item.ItemSteelIngot;
import kethas.railsplus.rail.RailSteel;
import kethas.railsplus.rail.RailSteelBrake;
import kethas.railsplus.rail.RailSteelPowered;
import kethas.railsplus.tile.TileEntityBlastFurnace;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class CommonProxy {
    public static IForgeRegistry<BlastFurnaceRecipe> BLAST_FURNACE_RECIPE_REGISTRY;
    public static CreativeTabs railsPlus;
    public static CreativeTabs railsPlusTransportation;
    public static ItemSteelIngot itemSteelIngot;
    public static ItemCoke itemCoke;
    public static BlockBlastFurnace blockBlastFurnace;
    public static RailSteel railSteel;
    public static RailSteelPowered railSteelPowered;
    public static RailSteelBrake railSteelBrake;

    public static BlastFurnaceRecipe getBlastFurnaceRecipe(ResourceLocation name) {
        return (BlastFurnaceRecipe)BLAST_FURNACE_RECIPE_REGISTRY.getValue(name);
    }

    public static BlastFurnaceRecipe getBlastFurnaceRecipe(ItemStack item) {
        return (BlastFurnaceRecipe)GameRegistry.findRegistry(BlastFurnaceRecipe.class).getValue(new ResourceLocation(item.func_77973_b().getRegistryName().func_110624_b(), item.func_77973_b().getRegistryName().func_110623_a() + "_" + item.func_77952_i()));
    }

    public void init(FMLInitializationEvent event) {
        this.registerRecipes();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void preInit(FMLPreInitializationEvent event) {
        railsPlus = new CreativeTabs("railsplus.general"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)itemSteelIngot);
            }
        };
        railsPlusTransportation = new CreativeTabs("railsplus.transportation"){

            public ItemStack func_78016_d() {
                return new ItemStack(ItemBlock.func_150898_a((Block)railSteelPowered));
            }
        };
        this.onNewRegistry(new RegistryEvent.NewRegistry());
        MinecraftForge.EVENT_BUS.register((Object)this);
        itemSteelIngot = new ItemSteelIngot();
        itemCoke = new ItemCoke();
        blockBlastFurnace = new BlockBlastFurnace();
        railSteel = new RailSteel();
        railSteelPowered = new RailSteelPowered();
        railSteelBrake = new RailSteelBrake();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RailsPlus.instance, (IGuiHandler)new RailsPlusGuiHandler());
    }

    @SubscribeEvent
    protected void onRegisterItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)itemSteelIngot);
        registry.register((IForgeRegistryEntry)itemCoke);
        registry.register((IForgeRegistryEntry)blockBlastFurnace.getItemBlock());
        registry.register((IForgeRegistryEntry)railSteel.getItemBlock());
        registry.register((IForgeRegistryEntry)railSteelPowered.getItemBlock());
        registry.register((IForgeRegistryEntry)railSteelBrake.getItemBlock());
    }

    @SubscribeEvent
    protected void onRegisterBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)blockBlastFurnace);
        registry.register((IForgeRegistryEntry)railSteel);
        registry.register((IForgeRegistryEntry)railSteelPowered);
        registry.register((IForgeRegistryEntry)railSteelBrake);
        GameRegistry.registerTileEntity(TileEntityBlastFurnace.class, (String)blockBlastFurnace.getRegistryName().toString());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    protected void onRegisterBlastFurnaceRecipes(RegistryEvent.Register<BlastFurnaceRecipe> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(){

            @Override
            @Nonnull
            public ItemStack getInput() {
                return new ItemStack(Items.field_151044_h);
            }

            @Override
            @Nonnull
            public ItemStack getOutput() {
                return new ItemStack((Item)itemCoke);
            }

            @Override
            public int getTime() {
                return 200;
            }
        });
        registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(){

            @Override
            @Nonnull
            public ItemStack getInput() {
                return new ItemStack(Items.field_151042_j);
            }

            @Override
            @Nonnull
            public ItemStack getOutput() {
                return new ItemStack((Item)itemSteelIngot);
            }

            @Override
            public int getTime() {
                return 200;
            }
        });
        if (RailsPlusConfig.enableFurnaceRecipesInBlastFurnace) {
            for (final Map.Entry<String, String> entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(){

                    @Override
                    @Nonnull
                    public ItemStack getInput() {
                        return (ItemStack)entry.getKey();
                    }

                    @Override
                    @Nonnull
                    public ItemStack getOutput() {
                        return (ItemStack)entry.getValue();
                    }

                    @Override
                    public int getTime() {
                        return 200;
                    }
                });
            }
        }
        for (Map.Entry<String, String> entry : RailsPlusConfig.oreDoublingRecipes.entrySet()) {
            Object outputs;
            Object inputs = entry.getKey().startsWith("@") ? OreDictionary.getOres((String)entry.getKey().substring(1), (boolean)false) : Collections.singletonList(new ItemStack((Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(entry.getKey()))));
            if (entry.getKey().startsWith("@")) {
                outputs = OreDictionary.getOres((String)entry.getValue().substring(1), (boolean)false);
                if (!outputs.isEmpty()) {
                    outputs = outputs.subList(0, 1);
                }
            } else {
                outputs = Collections.singletonList(new ItemStack((Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(entry.getValue()))));
            }
            Iterator iterator = inputs.iterator();
            while (iterator.hasNext()) {
                final ItemStack input = (ItemStack)iterator.next();
                if (input == null) continue;
                input.func_190920_e(1);
                Iterator iterator2 = outputs.iterator();
                while (iterator2.hasNext()) {
                    final ItemStack output = (ItemStack)iterator2.next();
                    if (output == null) continue;
                    output.func_190920_e(2);
                    registry.register((IForgeRegistryEntry)new BlastFurnaceRecipe(){

                        @Override
                        @Nonnull
                        public ItemStack getInput() {
                            return input.func_77946_l();
                        }

                        @Override
                        @Nonnull
                        public ItemStack getOutput() {
                            return output.func_77946_l();
                        }

                        @Override
                        public int getTime() {
                            return 200;
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    protected void onNewRegistry(RegistryEvent.NewRegistry e) {
        System.out.println("creating blast furnace registry");
        BLAST_FURNACE_RECIPE_REGISTRY = new RegistryBuilder().setType(BlastFurnaceRecipe.class).setName(new ResourceLocation("railsplus", "blastfurnace_recipes")).allowModification().create();
    }

    protected void registerRecipes() {
        OreDictionary.registerOre((String)"ingotSteel", (Item)itemSteelIngot);
        OreDictionary.registerOre((String)"coke", (Item)itemCoke);
    }
}

