/*
 * Decompiled with CFR 0.152.
 */
package kethas.railsplus.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kethas.railsplus.BlastFurnaceRecipe;
import kethas.railsplus.RailsPlusConfig;
import kethas.railsplus.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBlastFurnace
extends TileEntity
implements ITickable {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;
    public static final int[] FUEL_SLOTS = new int[]{0, 1};
    public static final int[] INPUT_SLOTS = new int[]{2};
    public static final int[] OUTPUT_SLOTS = new int[]{3};
    public static final int NUM_FUEL_SLOTS = 2;
    public static final int NUM_INPUT_SLOTS = 1;
    public static final int NUM_OUTPUT_SLOTS = 1;
    public static final int TOTAL_SLOTS = 4;
    public static final int[] BOTTOM_SLOTS = new int[]{0, 1, 3};
    public static final int[] SIDE_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] TOP_SLOTS = new int[]{2};
    public static final int MAX_TEMP = 1300;
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY;
    private ItemStackHandler inventory;
    private float timeLeft = 0.0f;
    private int fuelPending = 0;
    private int temperature = 0;
    private boolean isController = false;
    private TileEntityBlastFurnace controller = null;
    private IItemHandler bottomInventory = new IItemHandler(){

        private boolean containsSlot(int index) {
            for (int i : BOTTOM_SLOTS) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        public int getSlots() {
            return TileEntityBlastFurnace.this.getInventory().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.containsSlot(slot) ? TileEntityBlastFurnace.this.getInventory().getStackInSlot(slot) : null;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return stack;
            }
            return TileEntityBlastFurnace.this.getInventory().insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return ItemStack.field_190927_a;
            }
            return TileEntityBlastFurnace.this.getInventory().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (!this.containsSlot(slot)) {
                return 0;
            }
            return TileEntityBlastFurnace.this.getInventory().getSlotLimit(slot);
        }
    };
    private IItemHandler sideInventory = new IItemHandler(){

        private boolean containsSlot(int index) {
            for (int i : SIDE_SLOTS) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        public int getSlots() {
            return TileEntityBlastFurnace.this.getInventory().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.containsSlot(slot) ? TileEntityBlastFurnace.this.getInventory().getStackInSlot(slot) : null;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return stack;
            }
            return TileEntityBlastFurnace.this.getInventory().insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return ItemStack.field_190927_a;
            }
            return TileEntityBlastFurnace.this.getInventory().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (!this.containsSlot(slot)) {
                return 0;
            }
            return TileEntityBlastFurnace.this.getInventory().getSlotLimit(slot);
        }
    };
    private IItemHandler topInventory = new IItemHandler(){

        private boolean containsSlot(int index) {
            for (int i : TOP_SLOTS) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        public int getSlots() {
            return TileEntityBlastFurnace.this.getInventory().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.containsSlot(slot) ? TileEntityBlastFurnace.this.getInventory().getStackInSlot(slot) : null;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return stack;
            }
            return TileEntityBlastFurnace.this.getInventory().insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.containsSlot(slot)) {
                return ItemStack.field_190927_a;
            }
            return TileEntityBlastFurnace.this.getInventory().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (!this.containsSlot(slot)) {
                return 0;
            }
            return TileEntityBlastFurnace.this.getInventory().getSlotLimit(slot);
        }
    };
    private BlockPos controllerPos;

    public static float tempSpeedFunc(int temperature) {
        return (float)(RailsPlusConfig.blastFurnaceSpeedModifier * (double)(temperature < 900 ? 0.0f : (float)((double)(temperature - 900) / 490.0 * 1.5 + 1.0)));
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
            return 150;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return 100;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
            return 67;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150468_ap)) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150471_bO)) {
            return 100;
        }
        if (Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 16000;
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item != Items.field_151031_f && item != Items.field_151112_aM) {
            if (item == Items.field_151155_ap) {
                return 200;
            }
            if (item == Items.field_151044_h) {
                return 1600;
            }
            if (item == Items.field_151129_at) {
                return 20000;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g) && item != Items.field_151054_z) {
                if (item == Items.field_151072_bj) {
                    return 2400;
                }
                if (item instanceof ItemDoor && item != Items.field_151139_aw) {
                    return 200;
                }
                return item instanceof ItemBoat ? 400 : 0;
            }
            return 100;
        }
        return 300;
    }

    public ItemStackHandler createInventory(NonNullList<ItemStack> inventory) {
        return new ItemStackHandler(inventory){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 3 && stack != ItemStack.field_190927_a) {
                    return stack;
                }
                if ((slot == 0 || slot == 1) && TileEntityBlastFurnace.getItemBurnTime(stack) == 0) {
                    return stack;
                }
                if (slot == 2 && CommonProxy.getBlastFurnaceRecipe(stack) == null) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityBlastFurnace.this.sendUpdates();
            }
        };
    }

    public void func_73660_a() {
        if (!this.isController) {
            return;
        }
        int oldTemp = this.temperature;
        if (this.fuelPending > 0) {
            this.fuelPending -= 2;
            this.temperature += 2;
            if (this.fuelPending < 0) {
                this.fuelPending = 0;
            }
            if (this.temperature > 1300) {
                this.temperature = 1300;
            }
        }
        if (this.temperature > 0) {
            --this.temperature;
        }
        if (this.temperature < 0) {
            this.temperature = 0;
        }
        if (this.temperature > 900 && this.hasValidRecipe()) {
            BlastFurnaceRecipe recipe = CommonProxy.getBlastFurnaceRecipe(this.inventory.getStackInSlot(2));
            if (recipe != null) {
                if (this.timeLeft == 0.0f || this.timeLeft == -1.0f) {
                    this.timeLeft = recipe.getTime();
                }
                this.timeLeft -= TileEntityBlastFurnace.tempSpeedFunc(this.temperature);
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (this.timeLeft <= 0.0f) {
                    this.timeLeft = this.getTotalTime();
                    ItemStack stack = this.inventory.getStackInSlot(2);
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    this.inventory.setStackInSlot(2, stack);
                    stack = this.inventory.getStackInSlot(3);
                    if (stack.func_190926_b()) {
                        stack = recipe.getOutput().func_77946_l();
                    } else {
                        stack.func_190920_e(stack.func_190916_E() + recipe.getOutput().func_190916_E());
                    }
                    this.inventory.setStackInSlot(3, stack);
                    this.sendUpdates();
                }
            }
        } else {
            this.timeLeft = this.getTotalTime();
        }
        if (oldTemp > 100 && this.temperature < 100 || oldTemp < 100 && this.temperature > 100) {
            this.sendUpdates();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.consumeFuel(0);
        this.consumeFuel(1);
    }

    public boolean hasValidRecipe() {
        if (!this.isFormed()) {
            return false;
        }
        if (!this.isController) {
            return this.controller.hasValidRecipe();
        }
        BlastFurnaceRecipe recipe = CommonProxy.getBlastFurnaceRecipe(this.inventory.getStackInSlot(2));
        return recipe != null && (this.inventory.getStackInSlot(3).func_190926_b() || this.inventory.getStackInSlot(3).func_77969_a(recipe.getOutput()) && this.inventory.getStackInSlot(3).func_190916_E() + recipe.getOutput().func_190916_E() <= 64);
    }

    protected void consumeFuel(int slot) {
        if (this.fuelPending > 0 || !this.hasValidRecipe()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(slot);
        int burnTime = (int)((double)TileEntityBlastFurnace.getItemBurnTime(stack) * RailsPlusConfig.blastFurnaceFuelModifier);
        if (stack.func_190926_b()) {
            return;
        }
        if ((double)this.temperature <= 975.0) {
            stack.func_190920_e(stack.func_190916_E() - 1);
            this.inventory.setStackInSlot(slot, stack);
            this.fuelPending = burnTime / 4;
            this.temperature -= Math.min(30, burnTime / 4);
            this.sendUpdates();
        } else {
            double efficiency = burnTime / 4 / (1300 - this.temperature);
            if (efficiency <= 1.1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                this.inventory.setStackInSlot(slot, stack);
                this.fuelPending = burnTime / 4;
                this.temperature -= Math.min(30, burnTime / 4);
                this.sendUpdates();
            }
        }
    }

    public void checkIfFormed(boolean notifyNeighbours) {
        TileEntity te;
        BlockPos neighbour;
        int k;
        int j;
        int i;
        if (this.field_145850_b.field_72995_K || this.isFormed()) {
            return;
        }
        boolean formed = true;
        int validNeighbours = 0;
        block0: for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    neighbour = this.field_174879_c.func_177982_a(i, j, k);
                    te = this.field_145850_b.func_175625_s(neighbour);
                    if (te instanceof TileEntityBlastFurnace && !((TileEntityBlastFurnace)te).isFormed()) {
                        ++validNeighbours;
                        continue;
                    }
                    formed = false;
                    break block0;
                }
            }
        }
        if (formed && validNeighbours == 26) {
            this.isController = true;
            this.controller = this;
            this.inventory = this.createInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a));
            this.temperature = 0;
            this.fuelPending = 0;
            this.timeLeft = 0.0f;
            this.sendUpdates();
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0 || !((te = this.field_145850_b.func_175625_s(neighbour = this.field_174879_c.func_177982_a(i, j, k))) instanceof TileEntityBlastFurnace)) continue;
                        ((TileEntityBlastFurnace)te).controller = this;
                        ((TileEntityBlastFurnace)te).sendUpdates();
                    }
                }
            }
            return;
        }
        if (notifyNeighbours) {
            for (i = -1; i <= 1; ++i) {
                for (j = -3; j <= 3; ++j) {
                    for (k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0 || !((te = this.field_145850_b.func_175625_s(neighbour = this.field_174879_c.func_177982_a(i, j, k))) instanceof TileEntityBlastFurnace)) continue;
                        ((TileEntityBlastFurnace)te).checkIfFormed(false);
                    }
                }
            }
        }
    }

    public void deform() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isController && this.controller != null) {
            this.controller.deform();
            this.controller.isController = false;
            this.controller.controller = null;
        } else if (this.isController) {
            this.inventory = null;
            this.temperature = 0;
            this.fuelPending = 0;
            this.timeLeft = 0.0f;
            this.isController = false;
            this.controller = null;
            this.sendUpdates();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos neighbour;
                        TileEntity te;
                        if (i == 0 && j == 0 && k == 0 || !((te = this.field_145850_b.func_175625_s(neighbour = this.field_174879_c.func_177982_a(i, j, k))) instanceof TileEntityBlastFurnace) || this.field_145850_b.func_175623_d(neighbour)) continue;
                        ((TileEntityBlastFurnace)te).controller = null;
                        ((TileEntityBlastFurnace)te).temperature = 0;
                        ((TileEntityBlastFurnace)te).fuelPending = 0;
                        ((TileEntityBlastFurnace)te).timeLeft = 0.0f;
                        ((TileEntityBlastFurnace)te).sendUpdates();
                    }
                }
            }
        }
    }

    public int getState() {
        if (this.controller == null) {
            return 0;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.field_174879_c.equals((Object)this.controller.func_174877_v().func_177967_a(facing, 1))) continue;
            return this.getTemperature() > 100 ? 2 : 1;
        }
        return 0;
    }

    public boolean isFormed() {
        return this.controller != null && this.controller.isController;
    }

    public void onLoad() {
        if (!this.isFormed() && this.controllerPos != null) {
            this.controller = (TileEntityBlastFurnace)this.field_145850_b.func_175625_s(this.controllerPos);
        }
        this.checkIfFormed(true);
    }

    public void sendUpdates() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        this.func_70296_d();
        if (this.isController) {
            this.field_145850_b.func_175704_b(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        TileEntity te;
                        if (i == 0 && j == 0 && k == 0 || !((te = this.field_145850_b.func_175625_s(new BlockPos(i, j, k))) instanceof TileEntityBlastFurnace)) continue;
                        ((TileEntityBlastFurnace)te).sendUpdates();
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74767_n("railsplus:blastfurnace_formed")) {
            this.isController = compound.func_74767_n("railsplus:blastfurnace_iscontroller");
            if (this.isController) {
                this.controller = this;
            } else if (compound.func_74764_b("railsplus:blastfurnace_controller")) {
                this.controllerPos = BlockPos.func_177969_a((long)compound.func_74763_f("railsplus:blastfurnace_controller"));
            }
        } else {
            this.isController = false;
            this.controller = null;
            this.controllerPos = null;
        }
        if (compound.func_74764_b("railsplus:blastfurnace_inv")) {
            if (this.inventory == null) {
                this.inventory = this.createInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a));
            }
            this.inventory.deserializeNBT(compound.func_74775_l("railsplus:blastfurnace_inv"));
        }
        this.timeLeft = compound.func_74760_g("railsplus:blastfurnace_timeleft");
        this.fuelPending = compound.func_74762_e("railsplus:blastfurnace_fuelpending");
        this.temperature = compound.func_74762_e("railsplus:blastfurnace_temperature");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("railsplus:blastfurnace_formed", this.isFormed());
        if (this.isFormed()) {
            compound.func_74757_a("railsplus:blastfurnace_iscontroller", this.isController);
            if (this.controller != null) {
                compound.func_74772_a("railsplus:blastfurnace_controller", this.controller.field_174879_c.func_177986_g());
            }
        }
        if (this.inventory != null) {
            compound.func_74782_a("railsplus:blastfurnace_inv", (NBTBase)this.inventory.serializeNBT());
        }
        compound.func_74776_a("railsplus:blastfurnace_timeleft", this.timeLeft);
        compound.func_74768_a("railsplus:blastfurnace_fuelpending", this.fuelPending);
        compound.func_74768_a("railsplus:blastfurnace_temperature", this.temperature);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        this.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (!this.isFormed() && this.controllerPos != null) {
            this.controller = (TileEntityBlastFurnace)this.field_145850_b.func_175625_s(this.controllerPos);
        }
        if (this.isController) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        TileEntity te;
                        BlockPos neighbour;
                        if (i == 0 && j == 0 && k == 0 || this.field_145850_b.func_175623_d(neighbour = this.field_174879_c.func_177982_a(i, j, k)) || this.field_145850_b.func_180495_p(neighbour).func_177230_c() != CommonProxy.blockBlastFurnace || !((te = this.field_145850_b.func_175625_s(neighbour)) instanceof TileEntityBlastFurnace)) continue;
                        ((TileEntityBlastFurnace)te).controller = this;
                        ((TileEntityBlastFurnace)te).sendUpdates();
                    }
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.isController || this.controller != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            if (this.controller != null && !this.isController) {
                return this.controller.getCapability(capability, facing);
            }
            if (this.isController) {
                if (facing == null) {
                    return (T)this.inventory;
                }
                if (facing == EnumFacing.DOWN) {
                    return (T)this.bottomInventory;
                }
                if (facing == EnumFacing.UP) {
                    return (T)this.topInventory;
                }
                return (T)this.sideInventory;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemStackHandler getInventory() {
        if (!this.isController) {
            return this.controller == null ? null : this.controller.getInventory();
        }
        return this.inventory;
    }

    public boolean isController() {
        return this.isController;
    }

    public TileEntityBlastFurnace getController() {
        return this.controller;
    }

    public int getTemperature() {
        if (this.controller == null) {
            return -1;
        }
        if (!this.isController) {
            return this.controller.getTemperature();
        }
        return this.temperature;
    }

    public float getTimeLeft() {
        if (this.controller == null) {
            return -1.0f;
        }
        if (!this.isController) {
            return this.controller.getTimeLeft();
        }
        return this.timeLeft;
    }

    public int getTotalTime() {
        if (this.controller == null) {
            return -1;
        }
        if (!this.isController) {
            return this.controller.getTotalTime();
        }
        BlastFurnaceRecipe recipe = CommonProxy.getBlastFurnaceRecipe(this.inventory.getStackInSlot(2));
        if (recipe == null) {
            return -1;
        }
        return recipe.getTime();
    }
}

