/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockHighlight;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;

public class RenderBlockTarget {
    private final World world;
    private final BlockPos pos;
    private final RenderBlockHighlight highlightRenderer = new RenderBlockHighlight();
    public int ticksExisted = 0;
    public final GuiAnimatedStat stat;
    private final EntityPlayer player;
    public List<String> textList = new ArrayList<String>();
    private int hackTime;
    private final BlockTrackUpgradeHandler blockTracker;
    private TileEntity te;
    private int nEntries;

    public RenderBlockTarget(World world, EntityPlayer player, BlockPos pos, TileEntity te, BlockTrackUpgradeHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.te = te;
        this.blockTracker = blockTracker;
        ItemStack stack = ItemStack.field_190927_a;
        String title = world.func_180495_p(pos).func_177230_c().func_149732_F();
        try {
            IBlockState state = world.func_180495_p(pos);
            stack = state.func_177230_c().getPickBlock(state, Minecraft.func_71410_x().field_71476_x, world, pos, player);
            if (!stack.func_190926_b()) {
                title = stack.func_82833_r();
            }
        }
        catch (Throwable state) {
            // empty catch block
        }
        if (title.contains(".name")) {
            ITextComponent text = te.func_145748_c_();
            title = text == null ? "???" : text.func_150254_d();
        }
        this.stat = new GuiAnimatedStat(null, title, GuiAnimatedStat.StatIcon.of(stack), 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    private List<IBlockTrackEntry> getApplicableEntries() {
        return BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)this.world, this.pos, this.te);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public double getDistanceToEntity(Entity entity) {
        return entity.func_70011_f((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    public void maybeRefreshFromServer(List<IBlockTrackEntry> applicableTrackEntries) {
        if (applicableTrackEntries.stream().anyMatch(entry -> entry.shouldBeUpdatedFromServer(this.te))) {
            NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(this.pos));
        }
    }

    public void update() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.update();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        this.nEntries = applicableTrackEntries.size();
        if (this.world.func_82737_E() % 100L == 7L) {
            this.maybeRefreshFromServer(applicableTrackEntries);
        }
        if (!this.world.func_175623_d(this.pos)) {
            this.textList = new ArrayList<String>();
            if (this.ticksExisted > 120) {
                this.stat.closeWindow();
                for (IBlockTrackEntry entry : applicableTrackEntries) {
                    if (this.blockTracker.countBlockTrackersOfType(entry) > entry.spamThreshold()) continue;
                    this.stat.openWindow();
                    break;
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openWindow();
                    this.addBlockTrackInfo(this.textList, applicableTrackEntries);
                }
                this.stat.setText(this.textList);
            } else if (this.ticksExisted < -30) {
                this.stat.closeWindow();
                this.stat.setText(this.textList);
            }
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(float partialTicks) {
        double x = (double)this.pos.func_177958_n() + 0.5;
        double y = (double)this.pos.func_177956_o() + 0.5;
        double z = (double)this.pos.func_177952_p() + 0.5;
        GlStateManager.func_179090_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (!this.world.func_175623_d(this.pos)) {
            this.highlightRenderer.render(this.world, this.pos, partialTicks);
        }
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        GlStateManager.func_179098_w();
        if (!this.world.func_175623_d(this.pos)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179131_c((float)0.5f, (float)1.0f, (float)0.5f, (float)0.5f);
            if (this.ticksExisted > 120) {
                GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
                this.stat.render(-1, -1, partialTicks);
            } else if (this.ticksExisted > 50) {
                GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
                fontRenderer.func_78276_b("Acquiring Target...", 0, 0, 0x7F7F7F);
                fontRenderer.func_78276_b((int)targetAcquireProgress + "%", 37, 28, 12032);
            } else if (this.ticksExisted < -30) {
                GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
                this.stat.render(-1, -1, partialTicks);
                fontRenderer.func_78276_b("Lost Target!", 0, 0, 0xFF0000);
            }
        }
        GlStateManager.func_179121_F();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private void addBlockTrackInfo(List<String> textList, List<IBlockTrackEntry> entries) {
        entries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockAccess)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(MouseEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.handleMouseWheel(event.getDwheel());
        }
        return false;
    }
}

