/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.util.JsonToNBTConverter;
import me.desht.pneumaticcraft.common.util.NBTToJsonConverter;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class AmadronOffer {
    protected Object input;
    protected Object output;
    private String addedBy = null;

    public AmadronOffer(Object input, Object output) {
        this(input, output, null);
    }

    public AmadronOffer(Object input, Object output, String addedBy) {
        Validate.notNull((Object)input, (String)"Input item/fluid can't be null!", (Object[])new Object[0]);
        Validate.notNull((Object)output, (String)"Output item/fluid can't be null!", (Object[])new Object[0]);
        if (input instanceof ItemStack) {
            Validate.isTrue((!((ItemStack)input).func_190926_b() ? 1 : 0) != 0, (String)"Input item cannot be empty!", (Object[])new Object[0]);
        } else if (input instanceof FluidStack) {
            Validate.isTrue((((FluidStack)input).amount > 0 ? 1 : 0) != 0, (String)"Input fluid cannot be empty!", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("Input must be of type ItemStack or FluidStack. Input: " + input);
        }
        if (output instanceof ItemStack) {
            Validate.isTrue((!((ItemStack)output).func_190926_b() ? 1 : 0) != 0, (String)"Output item cannot be empty!", (Object[])new Object[0]);
        } else if (output instanceof FluidStack) {
            Validate.isTrue((((FluidStack)output).amount > 0 ? 1 : 0) != 0, (String)"Output fluid cannot be empty!", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("Output must be of type ItemStack or FluidStack. Output: " + input);
        }
        this.input = input;
        this.output = output;
        this.addedBy = addedBy;
    }

    public Object getInput() {
        return this.input;
    }

    public Object getOutput() {
        return this.output;
    }

    public String getVendor() {
        return I18n.func_74838_a((String)"gui.amadron");
    }

    public int getStock() {
        return -1;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public boolean passesQuery(String query) {
        String queryLow = query.toLowerCase();
        return this.getObjectName(this.getInput()).toLowerCase().contains(queryLow) || this.getObjectName(this.getOutput()).toLowerCase().contains(queryLow) || this.getVendor().toLowerCase().contains(queryLow);
    }

    private String getObjectName(Object object) {
        return object instanceof ItemStack ? ((ItemStack)object).func_82833_r() : ((FluidStack)object).getLocalizedName();
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        if (this.input instanceof ItemStack) {
            ((ItemStack)this.input).func_77955_b(subTag);
            tag.func_74782_a("inputItem", (NBTBase)subTag);
        } else {
            ((FluidStack)this.input).writeToNBT(subTag);
            tag.func_74782_a("inputFluid", (NBTBase)subTag);
        }
        subTag = new NBTTagCompound();
        if (this.output instanceof ItemStack) {
            ((ItemStack)this.output).func_77955_b(subTag);
            tag.func_74782_a("outputItem", (NBTBase)subTag);
        } else {
            ((FluidStack)this.output).writeToNBT(subTag);
            tag.func_74782_a("outputFluid", (NBTBase)subTag);
        }
    }

    public static AmadronOffer loadFromNBT(NBTTagCompound tag) {
        Object input = tag.func_74764_b("inputItem") ? new ItemStack(tag.func_74775_l("inputItem")) : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("inputFluid"));
        Object output = tag.func_74764_b("outputItem") ? new ItemStack(tag.func_74775_l("outputItem")) : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("outputFluid"));
        return new AmadronOffer(input, output);
    }

    public void writeToBuf(ByteBuf buf) {
        PacketSyncAmadronOffers.writeFluidOrItemStack(this.getInput(), buf);
        PacketSyncAmadronOffers.writeFluidOrItemStack(this.getOutput(), buf);
    }

    public static AmadronOffer readFromBuf(ByteBuf buf) {
        return new AmadronOffer(PacketSyncAmadronOffers.readFluidOrItemStack(buf), PacketSyncAmadronOffers.readFluidOrItemStack(buf));
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        JsonObject inputObject = new JsonObject();
        if (this.input instanceof ItemStack) {
            ItemStack stack = (ItemStack)this.input;
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            inputObject.addProperty("id", name == null ? "" : name.toString());
            inputObject.addProperty("damage", (Number)stack.func_77952_i());
            inputObject.addProperty("amount", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                inputObject.add("nbt", (JsonElement)NBTToJsonConverter.getObject(stack.func_77978_p()));
            }
        } else {
            inputObject.addProperty("id", ((FluidStack)this.input).getFluid().getName());
            inputObject.addProperty("amount", (Number)((FluidStack)this.input).amount);
        }
        object.add("input", (JsonElement)inputObject);
        JsonObject outputObject = new JsonObject();
        if (this.output instanceof ItemStack) {
            ItemStack stack = (ItemStack)this.output;
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            outputObject.addProperty("id", name == null ? "" : name.toString());
            outputObject.addProperty("damage", (Number)stack.func_77952_i());
            outputObject.addProperty("amount", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                outputObject.add("nbt", (JsonElement)NBTToJsonConverter.getObject(stack.func_77978_p()));
            }
        } else {
            outputObject.addProperty("id", ((FluidStack)this.output).getFluid().getName());
            outputObject.addProperty("amount", (Number)((FluidStack)this.output).amount);
        }
        object.add("output", (JsonElement)outputObject);
        if (this.addedBy != null) {
            object.addProperty("addedBy", this.addedBy);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AmadronOffer fromJson(JsonObject object) {
        FluidStack output;
        FluidStack input;
        JsonObject inputObject = object.getAsJsonObject("input");
        if (inputObject.has("damage")) {
            Item item = Item.func_111206_d((String)inputObject.get("id").getAsString());
            if (item == null) {
                Log.error("Invalid Amadron Offer input item. Invalid item name: " + inputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            input = new ItemStack(item, inputObject.get("amount").getAsInt(), inputObject.get("damage").getAsInt());
            if (inputObject.has("nbt")) {
                ((ItemStack)input).func_77982_d(JsonToNBTConverter.getTag(inputObject.getAsJsonObject("nbt")));
            }
        } else {
            Fluid fluid = FluidRegistry.getFluid((String)inputObject.get("id").getAsString());
            if (fluid == null) {
                Log.error("Invalid Amadron Offer input fluid. Invalid fluid name: " + inputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            input = new FluidStack(fluid, inputObject.get("amount").getAsInt());
        }
        JsonObject outputObject = object.getAsJsonObject("output");
        if (outputObject.has("damage")) {
            Item item = Item.func_111206_d((String)outputObject.get("id").getAsString());
            if (item == null) {
                Log.error("Invalid Amadron Offer output item. Invalid item name: " + outputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            output = new ItemStack(item, outputObject.get("amount").getAsInt(), outputObject.get("damage").getAsInt());
            if (outputObject.has("nbt")) {
                ((ItemStack)output).func_77982_d(JsonToNBTConverter.getTag(outputObject.getAsJsonObject("nbt")));
            }
        } else {
            Fluid fluid = FluidRegistry.getFluid((String)outputObject.get("id").getAsString());
            if (fluid == null) {
                Log.error("Invalid Amadron Offer output fluid. Invalid fluid name: " + outputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            output = new FluidStack(fluid, outputObject.get("amount").getAsInt());
        }
        String addedBy = object.has("addedBy") ? object.get("addedBy").getAsString() : null;
        return new AmadronOffer(input, output, addedBy);
    }

    public int hashCode() {
        int code = this.getObjectHashCode(this.getInput());
        code = 31 * code + this.getObjectHashCode(this.getOutput());
        code = 31 * code + this.getVendor().hashCode();
        return code;
    }

    public String toString() {
        return String.format("[in = %s, out = %s]", this.input, this.output);
    }

    private int getObjectHashCode(Object o) {
        if (o instanceof FluidStack) {
            return o.hashCode();
        }
        ItemStack stack = (ItemStack)o;
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        return (name == null ? 0 : name.hashCode()) + stack.func_190916_E() * 19 + stack.func_77960_j() * 37;
    }

    public boolean equals(Object o) {
        AmadronOffer offer;
        if (o instanceof AmadronOffer && (offer = (AmadronOffer)o).getInput().getClass() == this.getInput().getClass() && offer.getOutput().getClass() == this.getOutput().getClass()) {
            ItemStack s2;
            ItemStack s1;
            if (offer.getInput() instanceof ItemStack ? !ItemStack.func_77989_b((ItemStack)(s1 = (ItemStack)offer.getInput()), (ItemStack)(s2 = (ItemStack)this.getInput())) : !(s1 = (FluidStack)offer.getInput()).isFluidEqual((FluidStack)(s2 = (FluidStack)this.getInput())) || s1.amount != s2.amount) {
                return false;
            }
            if (offer.getOutput() instanceof ItemStack ? !ItemStack.func_77989_b((ItemStack)(s1 = (ItemStack)offer.getOutput()), (ItemStack)(s2 = (ItemStack)this.getOutput())) : !(s1 = (FluidStack)offer.getOutput()).isFluidEqual((FluidStack)(s2 = (FluidStack)this.getOutput())) || s1.amount != s2.amount) {
                return false;
            }
            return this.getVendor().equals(offer.getVendor());
        }
        return false;
    }

    public static enum TradeType {
        PLAYER,
        PERIODIC,
        STATIC;

    }
}

