/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariants;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.List;
import java.util.Random;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.BiomeDictionary;

@MethodsReturnNonnullByDefault
public class MapGenBetterMineshaft
extends MapGenMineshaft {
    protected boolean func_75047_a(int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos((chunkX << 4) + 8, 64, (chunkZ << 4) + 8));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            return false;
        }
        return this.field_75038_b.nextDouble() < Configuration.mineshaftSpawnRate;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos((chunkX << 4) + 8, 64, (chunkZ << 4) + 8));
        MineshaftVariantSettings settings = MineshaftVariants.get().getDefault();
        boolean found = true;
        for (MineshaftVariantSettings variant : MineshaftVariants.get().getVariants()) {
            for (List<BiomeDictionary.Type> tagList : variant.biomeTags) {
                found = true;
                for (BiomeDictionary.Type tag : tagList) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)tag)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                settings = variant;
                break;
            }
            if (!found) continue;
            break;
        }
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, settings);
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random random, int chunkX, int chunkZ, MineshaftVariantSettings settings) {
            super(chunkX, chunkZ);
            EnumFacing direction = EnumFacing.NORTH;
            int r = random.nextInt(4);
            switch (r) {
                case 0: {
                    direction = EnumFacing.NORTH;
                    break;
                }
                case 1: {
                    direction = EnumFacing.SOUTH;
                    break;
                }
                case 2: {
                    direction = EnumFacing.EAST;
                    break;
                }
                case 3: {
                    direction = EnumFacing.WEST;
                }
            }
            int y = random.nextInt(Configuration.maxY - Configuration.minY + 1) + Configuration.minY;
            BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos((chunkX << 4) + 2, y, (chunkZ << 4) + 2);
            VerticalEntrance entryPoint = new VerticalEntrance(0, -1, random, startingPos, direction, settings);
            this.field_75075_a.add(entryPoint);
            ((MineshaftPiece)entryPoint).func_74861_a(entryPoint, this.field_75075_a, random);
            this.func_75072_c();
        }
    }
}

