/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.integration.Integrations;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.util.Pair;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class BigTunnel
extends MineshaftPiece {
    private final List<BlockPos> smallShaftLeftEntrances = Lists.newLinkedList();
    private final List<BlockPos> smallShaftRightEntrances = Lists.newLinkedList();
    private final List<StructureBoundingBox> sideRoomEntrances = Lists.newLinkedList();
    private final List<Integer> bigSupports = Lists.newLinkedList();
    private final List<Integer> smallSupports = Lists.newLinkedList();
    private final List<Pair<Integer, Integer>> gravelDeposits = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 8;
    private static final int MAIN_AXIS_LEN = 24;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 7;
    private static final int LOCAL_Z_END = 23;

    public BigTunnel() {
    }

    public BigTunnel(int i, int pieceChainLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        NBTTagList listTag1 = new NBTTagList();
        NBTTagList listTag2 = new NBTTagList();
        NBTTagList listTag3 = new NBTTagList();
        NBTTagList listTag4 = new NBTTagList();
        NBTTagList listTag5 = new NBTTagList();
        NBTTagList listTag6 = new NBTTagList();
        this.smallShaftLeftEntrances.forEach(pos -> listTag1.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})));
        this.smallShaftRightEntrances.forEach(pos -> listTag2.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})));
        this.sideRoomEntrances.forEach(blockBox -> listTag3.func_74742_a((NBTBase)blockBox.func_151535_h()));
        this.bigSupports.forEach(z -> listTag4.func_74742_a((NBTBase)new NBTTagInt(z.intValue())));
        this.smallSupports.forEach(z -> listTag5.func_74742_a((NBTBase)new NBTTagInt(z.intValue())));
        this.gravelDeposits.forEach(pair -> listTag6.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{(Integer)pair.getLeft(), (Integer)pair.getRight()})));
        tag.func_74782_a("SmallShaftLeftEntrances", (NBTBase)listTag1);
        tag.func_74782_a("SmallShaftRightEntrances", (NBTBase)listTag2);
        tag.func_74782_a("SideRoomEntrances", (NBTBase)listTag3);
        tag.func_74782_a("BigSupports", (NBTBase)listTag4);
        tag.func_74782_a("SmallSupports", (NBTBase)listTag5);
        tag.func_74782_a("GravelDeposits", (NBTBase)listTag6);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        int i;
        super.func_143011_b(tag, templateManager);
        NBTTagList listTag1 = tag.func_150295_c("SmallShaftLeftEntrances", 11);
        NBTTagList listTag2 = tag.func_150295_c("SmallShaftRightEntrances", 11);
        NBTTagList listTag3 = tag.func_150295_c("SideRoomEntrances", 11);
        NBTTagList listTag4 = tag.func_150295_c("BigSupports", 3);
        NBTTagList listTag5 = tag.func_150295_c("SmallSupports", 3);
        NBTTagList listTag6 = tag.func_150295_c("GravelDeposits", 11);
        for (i = 0; i < listTag1.func_74745_c(); ++i) {
            this.smallShaftLeftEntrances.add(new BlockPos(listTag1.func_150306_c(i)[0], listTag1.func_150306_c(i)[1], listTag1.func_150306_c(i)[2]));
        }
        for (i = 0; i < listTag2.func_74745_c(); ++i) {
            this.smallShaftRightEntrances.add(new BlockPos(listTag2.func_150306_c(i)[0], listTag2.func_150306_c(i)[1], listTag2.func_150306_c(i)[2]));
        }
        for (i = 0; i < listTag3.func_74745_c(); ++i) {
            this.sideRoomEntrances.add(new StructureBoundingBox(listTag3.func_150306_c(i)));
        }
        for (i = 0; i < listTag4.func_74745_c(); ++i) {
            this.bigSupports.add(listTag4.func_186858_c(i));
        }
        for (i = 0; i < listTag5.func_74745_c(); ++i) {
            this.smallSupports.add(listTag5.func_186858_c(i));
        }
        for (i = 0; i < listTag6.func_74745_c(); ++i) {
            this.gravelDeposits.add(new Pair<Integer, Integer>(listTag6.func_150306_c(i)[0], listTag6.func_150306_c(i)[1]));
        }
    }

    public static StructureBoundingBox determineBoxPosition(int x, int y, int z, EnumFacing direction) {
        return BoxUtil.boxFromCoordsWithRotation(x, y, z, 9, 8, 24, direction);
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
        int pieceLen = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? this.field_74887_e.func_78880_d() : this.field_74887_e.func_78883_b();
        this.buildSideRoomsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSideRoomsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSupports(random);
        this.buildGravelDeposits(random);
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 8, 23)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 8, 7, 23, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 8, 0, 23, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 7, 4, 23, AIR);
        this.fill(world, box, 2, 4, 0, 6, 5, 23, AIR);
        this.fill(world, box, 3, 6, 0, 5, 6, 23, AIR);
        this.replaceAir(world, box, 1, 0, 0, 7, 0, 23, this.getMainBlock());
        this.generateSmallShaftEntrances(world, box, random);
        this.generateSideRoomOpenings(world, box, random);
        this.generateLegs(world, box, random);
        this.generateBigSupports(world, box, random);
        this.generateSmallSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateChestCarts(world, box, random, LootTableList.field_186424_f);
        this.generateTntCarts(world, box, random);
        this.generateGravelDeposits(world, box, random);
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 7, 6, 23);
        this.addVines(world, box, random, 1, 0, 1, 7, 7, 22);
        this.generateLanterns(world, box, random);
        this.generateCobwebs(world, box, random);
        return true;
    }

    private void generateLegs(World world, StructureBoundingBox box, Random random) {
        if (this.settings.legVariant == 1) {
            this.generateLegsVariant1(world, box, random);
        } else {
            this.generateLegsVariant2(world, box, random);
        }
    }

    private void generateLegsVariant1(World world, StructureBoundingBox box, Random random) {
        IBlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof BlockFence) {
            supportBlock = supportBlock.func_177226_a((IProperty)BlockFence.field_176526_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockFence.field_176527_M, (Comparable)Boolean.valueOf(true));
        } else if (supportBlock.func_177230_c() instanceof BlockWall) {
            supportBlock = supportBlock.func_177226_a((IProperty)BlockWall.field_176254_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockWall.field_176258_N, (Comparable)Boolean.valueOf(true));
        }
        this.generateLeg(world, random, box, 1, 0, this.getLegSelector());
        this.replaceAir(world, box, 1, -1, 1, 1, -1, 5, supportBlock);
        this.replaceAir(world, box, 1, -2, 1, 1, -2, 3, supportBlock);
        this.replaceAir(world, box, 1, -3, 1, 1, -3, 2, supportBlock);
        this.replaceAir(world, box, 1, -5, 1, 1, -4, 1, supportBlock);
        this.replaceAir(world, box, 1, -1, 6, 1, -1, 10, supportBlock);
        this.replaceAir(world, box, 1, -2, 8, 1, -2, 10, supportBlock);
        this.replaceAir(world, box, 1, -3, 9, 1, -3, 10, supportBlock);
        this.replaceAir(world, box, 1, -5, 10, 1, -4, 10, supportBlock);
        this.generateLeg(world, random, box, 1, 11, this.getLegSelector());
        this.generateLeg(world, random, box, 1, 12, this.getLegSelector());
        this.replaceAir(world, box, 1, -1, 13, 1, -1, 17, supportBlock);
        this.replaceAir(world, box, 1, -2, 13, 1, -2, 15, supportBlock);
        this.replaceAir(world, box, 1, -3, 13, 1, -3, 14, supportBlock);
        this.replaceAir(world, box, 1, -5, 13, 1, -4, 13, supportBlock);
        this.replaceAir(world, box, 1, -1, 18, 1, -1, 22, supportBlock);
        this.replaceAir(world, box, 1, -2, 20, 1, -2, 22, supportBlock);
        this.replaceAir(world, box, 1, -3, 21, 1, -3, 22, supportBlock);
        this.replaceAir(world, box, 1, -5, 22, 1, -4, 22, supportBlock);
        this.generateLeg(world, random, box, 1, 23, this.getLegSelector());
        this.generateLeg(world, random, box, 7, 0, this.getLegSelector());
        this.replaceAir(world, box, 7, -1, 1, 7, -1, 5, supportBlock);
        this.replaceAir(world, box, 7, -2, 1, 7, -2, 3, supportBlock);
        this.replaceAir(world, box, 7, -3, 1, 7, -3, 2, supportBlock);
        this.replaceAir(world, box, 7, -5, 1, 7, -4, 1, supportBlock);
        this.replaceAir(world, box, 7, -1, 6, 7, -1, 10, supportBlock);
        this.replaceAir(world, box, 7, -2, 8, 7, -2, 10, supportBlock);
        this.replaceAir(world, box, 7, -3, 9, 7, -3, 10, supportBlock);
        this.replaceAir(world, box, 7, -5, 10, 7, -4, 10, supportBlock);
        this.generateLeg(world, random, box, 7, 11, this.getLegSelector());
        this.generateLeg(world, random, box, 7, 12, this.getLegSelector());
        this.replaceAir(world, box, 7, -1, 13, 7, -1, 17, supportBlock);
        this.replaceAir(world, box, 7, -2, 13, 7, -2, 15, supportBlock);
        this.replaceAir(world, box, 7, -3, 13, 7, -3, 14, supportBlock);
        this.replaceAir(world, box, 7, -5, 13, 7, -4, 13, supportBlock);
        this.replaceAir(world, box, 7, -1, 18, 7, -1, 22, supportBlock);
        this.replaceAir(world, box, 7, -2, 20, 7, -2, 22, supportBlock);
        this.replaceAir(world, box, 7, -3, 21, 7, -3, 22, supportBlock);
        this.replaceAir(world, box, 7, -5, 22, 7, -4, 22, supportBlock);
        this.generateLeg(world, random, box, 7, 23, this.getLegSelector());
    }

    private void generateLegsVariant2(World world, StructureBoundingBox box, Random random) {
        for (int z = 0; z <= 23; z += 7) {
            this.generateLeg(world, random, box, 2, z + 1, this.getLegSelector());
            this.generateLeg(world, random, box, 6, z + 1, this.getLegSelector());
            this.replaceAir(world, box, random, 1, -1, z, 7, -1, z + 2, this.getLegSelector());
            this.replaceAir(world, box, random, 2, -1, z + 3, 2, -1, z + 3, this.getLegSelector());
            this.replaceAir(world, box, random, 6, -1, z + 3, 6, -1, z + 3, this.getLegSelector());
            this.replaceAir(world, box, random, 3, -1, z + 3, 5, -1, z + 6, this.getLegSelector());
            this.replaceAir(world, box, random, 2, -1, z + 6, 2, -1, z + 6, this.getLegSelector());
            this.replaceAir(world, box, random, 6, -1, z + 6, 6, -1, z + 6, this.getLegSelector());
            this.replaceAir(world, box, random, 2, -2, z, 2, -2, z, this.getLegSelector());
            this.replaceAir(world, box, random, 6, -2, z, 6, -2, z, this.getLegSelector());
            this.replaceAir(world, box, random, 2, -2, z + 2, 2, -2, z + 2, this.getLegSelector());
            this.replaceAir(world, box, random, 6, -2, z + 2, 6, -2, z + 2, this.getLegSelector());
            this.replaceAir(world, box, random, 1, -2, z + 1, 1, -2, z + 1, this.getLegSelector());
            this.replaceAir(world, box, random, 7, -2, z + 1, 7, -2, z + 1, this.getLegSelector());
            this.replaceAir(world, box, random, 3, -2, z + 1, 3, -2, z + 1, this.getLegSelector());
            this.replaceAir(world, box, random, 5, -2, z + 1, 5, -2, z + 1, this.getLegSelector());
        }
    }

    private void generateGravelDeposits(World world, StructureBoundingBox box, Random random) {
        this.gravelDeposits.forEach(pair -> {
            int z = (Integer)pair.getLeft();
            int side = (Integer)pair.getRight();
            switch (side) {
                default: {
                    this.replaceAir(world, box, 1, 1, z, 1, 2, z + 2, this.getGravel());
                    this.replaceAir(world, box, 1, 3, z + 1, 1, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 1, 3, z, 1, 3, z + 2, this.getGravel());
                    this.replaceAir(world, box, 2, 1, z + 1, 2, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAir(world, box, 2, 1, z, 2, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 3, 1, z, 3, 1, z + 2, this.getGravel());
                    break;
                }
                case 1: {
                    this.replaceAir(world, box, 7, 1, z, 7, 2, z + 2, this.getGravel());
                    this.replaceAir(world, box, 7, 3, z + 1, 7, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 7, 3, z, 7, 3, z + 2, this.getGravel());
                    this.replaceAir(world, box, 6, 1, z + 1, 6, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAir(world, box, 6, 1, z, 6, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 5, 1, z, 5, 1, z + 2, this.getGravel());
                }
            }
        });
    }

    private void generateCobwebs(World world, StructureBoundingBox box, Random random) {
        this.smallSupports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 2, 3, z - 1, 6, 4, z + 1, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 3, 5, (int)z, 5, 5, (int)z, Blocks.field_150321_G.func_176223_P());
        });
        this.bigSupports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 1, 1, (int)z, 1, 4, z + 2, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 7, 1, (int)z, 7, 4, z + 2, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 2, 5, (int)z, 6, 5, z + 2, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 2, 4, z + 1, 6, 4, z + 1, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 3, 6, z + 1, 5, 6, z + 1, Blocks.field_150321_G.func_176223_P());
        });
    }

    private void generateChestCarts(World world, StructureBoundingBox box, Random random, ResourceLocation lootTableId) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos blockPos;
            if (!(random.nextFloat() < Configuration.spawnRates.mainShaftChestMinecartSpawnRate) || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(1), this.func_74873_b(4, z)))) || world.func_180495_p(blockPos.func_177977_b()) == AIR) continue;
            EntityMinecartChest chestMinecartEntity = new EntityMinecartChest(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            chestMinecartEntity.func_184289_a(lootTableId, random.nextLong());
            world.func_72838_d((Entity)chestMinecartEntity);
        }
    }

    private void generateTntCarts(World world, StructureBoundingBox box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos blockPos;
            if (!(random.nextFloat() < Configuration.spawnRates.mainShaftTntMinecartSpawnRate) || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(1), this.func_74873_b(4, z)))) || world.func_180495_p(blockPos.func_177977_b()) == AIR) continue;
            EntityMinecartTNT tntMinecartEntity = new EntityMinecartTNT(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            world.func_72838_d((Entity)tntMinecartEntity);
        }
    }

    private void generateBigSupports(World world, StructureBoundingBox box, Random random) {
        this.bigSupports.forEach(z -> {
            this.chanceFill(world, box, random, 0.6f, 1, 1, (int)z, 2, 1, z + 2, this.getMainSlab());
            this.chanceFill(world, box, random, 0.6f, 6, 1, (int)z, 7, 1, z + 2, this.getMainSlab());
            this.func_175811_a(world, this.getMainBlock(), 1, 1, z + 1, box);
            this.func_175811_a(world, this.getMainBlock(), 7, 1, z + 1, box);
            this.func_175811_a(world, this.getMainBlock(), 1, 4, z + 1, box);
            this.func_175811_a(world, this.getMainBlock(), 7, 4, z + 1, box);
            this.fill(world, box, 2, 5, z + 1, 6, 5, z + 1, this.getMainBlock());
            this.fill(world, box, 1, 2, z + 1, 1, 3, z + 1, this.getSupportBlock());
            this.fill(world, box, 7, 2, z + 1, 7, 3, z + 1, this.getSupportBlock());
            this.chanceReplaceNonAir(world, box, random, 0.4f, 2, 5, z + 1, 6, 5, z + 1, this.getSupportBlock());
        });
    }

    private void generateSmallSupports(World world, StructureBoundingBox box, Random random) {
        IBlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof BlockFence) {
            supportBlock = this.getSupportBlock().func_177226_a((IProperty)BlockFence.field_176528_N, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockFence.field_176525_b, (Comparable)Boolean.valueOf(true));
        } else if (supportBlock.func_177230_c() instanceof BlockWall) {
            supportBlock = this.getSupportBlock().func_177226_a((IProperty)BlockWall.field_176259_O, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockWall.field_176257_M, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.smallSupports) {
            this.func_175811_a(world, this.getMainBlock(), 2, 1, z, box);
            this.func_175811_a(world, this.getMainBlock(), 6, 1, z, box);
            this.func_175811_a(world, this.getSupportBlock(), 2, 2, z, box);
            this.func_175811_a(world, this.getSupportBlock(), 6, 2, z, box);
            this.func_175811_a(world, this.getMainBlock(), 2, 3, z, box);
            this.func_175811_a(world, this.getMainBlock(), 6, 3, z, box);
            this.fill(world, box, 3, 4, z, 5, 4, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.5f, 3, 4, z, 5, 4, z, supportBlock);
            this.chanceFill(world, box, random, 0.4f, 2, 3, z, 6, 3, z, supportBlock);
            this.func_175811_a(world, supportBlock, 3, 3, z, box);
            this.func_175811_a(world, supportBlock, 5, 3, z, box);
        }
    }

    private void generateLanterns(World world, StructureBoundingBox box, Random random) {
        IBlockState lantern = Integrations.getLantern(random);
        if (lantern == null) {
            return;
        }
        for (int z = 0; z <= 23; ++z) {
            if (!(random.nextFloat() < Configuration.spawnRates.lanternSpawnRate * 3.0f) || this.func_175807_a(world, 4, 7, z, box) == AIR) continue;
            this.func_175811_a(world, lantern, 4, 6, z, box);
            if (Integrations.VARIED_COMMODITIES.isLanternVariedCommoditiesCandle(lantern)) {
                Integrations.VARIED_COMMODITIES.spawnCandleLanternEntity(world, this.func_74865_a(4, z), this.func_74862_a(6), this.func_74873_b(4, z));
            } else if (Integrations.VARIED_COMMODITIES.isLanternVariedCommoditiesLamp(lantern)) {
                Integrations.VARIED_COMMODITIES.spawnLampLanternEntity(world, this.func_74865_a(4, z), this.func_74862_a(6), this.func_74873_b(4, z));
            }
            z += 20;
        }
    }

    private void generateRails(World world, StructureBoundingBox box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            if (!(random.nextFloat() < 0.3f)) continue;
            this.fill(world, box, 4, 1, z, 4, 1, z + 1, Blocks.field_150448_aq.func_176223_P());
            ++z;
        }
    }

    private void generateSmallShaftEntrances(World world, StructureBoundingBox box, Random random) {
        this.smallShaftLeftEntrances.forEach(entrancePos -> {
            int x = entrancePos.func_177958_n();
            int y = entrancePos.func_177956_o();
            int z = entrancePos.func_177952_p();
            this.fill(world, box, x, y, z, x, y, z + 2, AIR);
            this.func_175811_a(world, this.getSupportBlock(), x, y + 1, z, box);
            this.func_175811_a(world, this.getSupportBlock(), x, y + 1, z + 2, box);
            this.fill(world, box, x + 1, y, z, x + 1, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x + 1, y, z + 2, x + 1, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
            this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
        });
        this.smallShaftRightEntrances.forEach(entrancePos -> {
            int x = entrancePos.func_177958_n();
            int y = entrancePos.func_177956_o();
            int z = entrancePos.func_177952_p();
            this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
            this.fill(world, box, x + 1, y, z, x + 1, y, z + 2, AIR);
            this.func_175811_a(world, this.getSupportBlock(), x + 1, y + 1, z, box);
            this.func_175811_a(world, this.getSupportBlock(), x + 1, y + 1, z + 2, box);
            this.fill(world, box, x, y, z, x, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x, y, z + 2, x, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
        });
    }

    private void generateSideRoomOpenings(World world, StructureBoundingBox box, Random random) {
        this.sideRoomEntrances.forEach(entranceBox -> {
            this.replaceAir(world, box, random, entranceBox.field_78897_a, 0, entranceBox.field_78896_c, entranceBox.field_78893_d, 0, entranceBox.field_78892_f, this.getBrickSelector());
            switch (random.nextInt(3)) {
                case 0: {
                    this.fill(world, box, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 2, entranceBox.field_78893_d, entranceBox.field_78894_e, entranceBox.field_78892_f - 2, AIR);
                    return;
                }
                case 1: {
                    this.fill(world, box, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 2, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 2, AIR);
                    this.fill(world, box, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 4, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 5, AIR);
                    this.fill(world, box, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 7, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 7, AIR);
                    return;
                }
            }
        });
    }

    private void buildGravelDeposits(Random random) {
        for (int z = 0; z <= 21; ++z) {
            int r = random.nextInt(20);
            int currPos = z;
            if (r == 0) {
                this.gravelDeposits.add(new Pair<Integer, Integer>(currPos, 0));
                z += 5;
                continue;
            }
            if (r != 1) continue;
            this.gravelDeposits.add(new Pair<Integer, Integer>(currPos, 1));
            z += 5;
        }
    }

    private void buildSupports(Random random) {
        int counter = 0;
        int MAX_COUNT = 10;
        for (int z = 0; z <= 21; ++z) {
            ++counter;
            boolean blockingEntrance = false;
            for (BlockPos entrancePos : this.smallShaftLeftEntrances) {
                if (entrancePos.func_177952_p() > z + 2 || z > entrancePos.func_177952_p() + 2) continue;
                blockingEntrance = true;
                break;
            }
            for (BlockPos entrancePos : this.smallShaftRightEntrances) {
                if (entrancePos.func_177952_p() > z + 2 || z > entrancePos.func_177952_p() + 2) continue;
                blockingEntrance = true;
                break;
            }
            if (blockingEntrance) continue;
            int r = random.nextInt(8);
            if (r == 0 || counter >= 10) {
                this.bigSupports.add(z);
                counter = 0;
                z += 3;
                continue;
            }
            if (r != 1) continue;
            this.smallSupports.add(z);
            counter = 0;
            z += 3;
        }
    }

    private void buildSideRoomsLeft(StructureComponent structurePiece, List<StructureComponent> list, Random random, EnumFacing direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!(random.nextFloat() < Configuration.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    EnumFacing nextPieceDirection = EnumFacing.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n - 9, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    EnumFacing nextPieceDirection = EnumFacing.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n + 9, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case WEST: {
                    EnumFacing nextPieceDirection = EnumFacing.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n - 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case EAST: {
                    EnumFacing nextPieceDirection = EnumFacing.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n + 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(0, 1, n, 0, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSideRoomsRight(StructureComponent structurePiece, List<StructureComponent> list, Random random, EnumFacing direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!(random.nextFloat() < Configuration.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    EnumFacing nextPieceDirection = EnumFacing.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    EnumFacing nextPieceDirection = EnumFacing.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case WEST: {
                    EnumFacing nextPieceDirection = EnumFacing.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case EAST: {
                    EnumFacing nextPieceDirection = EnumFacing.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new StructureBoundingBox(8, 1, n, 8, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSmallShaftsLeft(StructureComponent structurePiece, List<StructureComponent> list, Random random, EnumFacing direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 4; ++n) {
            if (!(random.nextFloat() < Configuration.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    EnumFacing nextPieceDirection = EnumFacing.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                    break;
                }
                case SOUTH: {
                    EnumFacing nextPieceDirection = EnumFacing.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case WEST: {
                    EnumFacing nextPieceDirection = EnumFacing.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case EAST: {
                    EnumFacing nextPieceDirection = EnumFacing.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }

    private void buildSmallShaftsRight(StructureComponent structurePiece, List<StructureComponent> list, Random random, EnumFacing direction, int pieceLen) {
        for (int n = 5; n < pieceLen; ++n) {
            if (!(random.nextFloat() < Configuration.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    EnumFacing nextPieceDirection = EnumFacing.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                    break;
                }
                case SOUTH: {
                    EnumFacing nextPieceDirection = EnumFacing.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case WEST: {
                    EnumFacing nextPieceDirection = EnumFacing.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case EAST: {
                    EnumFacing nextPieceDirection = EnumFacing.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }
}

