/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class LongEditor
extends AbstractParameterEditor {
    private TextField field;
    private ToggleButton hexMode;

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.field = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow());
        constantPanel.addChild((Widget)this.field);
        this.hexMode = (ToggleButton)new ToggleButton(mc, gui).addButtonEvent(widget -> this.updateHex()).setCheckMarker(true).setText("Hex");
        constantPanel.addChild((Widget)this.hexMode);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_LONG);
    }

    private void updateHex() {
        Long i;
        String value = this.field.getText();
        if (this.hexMode.isPressed()) {
            if (!value.startsWith("$")) {
                try {
                    long i2 = Long.parseLong(value);
                    value = "$" + Long.toHexString(i2);
                    this.field.setText(value);
                }
                catch (NumberFormatException i2) {}
            }
        } else if (value.startsWith("$") && (i = LongEditor.parseLongSafe(value)) != null) {
            this.field.setText(String.valueOf(i));
        }
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant(LongEditor.parseLongSafe(this.field.getText()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.setText("");
        } else {
            try {
                this.field.setText(Long.toString((Long)value.getValue()));
            }
            catch (Exception e) {
                this.field.setText("");
            }
        }
        this.updateHex();
    }
}

