/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.craftstudio;

import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.BlockDimensionalPosition;
import com.mia.craftstudio.minecraft.CraftStudioModelWrapper;
import com.mia.craftstudio.minecraft.IAnimatedTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.CameraObscura;
import team.thegoldenhoe.cameraobscura.common.craftstudio.BlockFake;
import team.thegoldenhoe.cameraobscura.common.craftstudio.BlockProps;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileFake;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public class TileProps
extends TileEntity
implements IAnimatedTile {
    public int oldLight = -1;
    public int type = 0;
    public int rotation;
    protected boolean isRunning = false;
    public Random rand = new Random();
    public Set<BlockPos> slaves = new HashSet<BlockPos>();
    public Map<String, String> tileParams = new HashMap<String, String>();
    protected boolean initialized = false;
    private BlockDimensionalPosition dimpos = null;

    public void init() {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public BlockDimensionalPosition getBlockPosDim() {
        if (this.dimpos == null) {
            this.dimpos = new BlockDimensionalPosition(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
        return this.dimpos;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.dimpos = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.dimpos = null;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.dimpos = null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = compound.func_74762_e("BlockType");
        this.rotation = compound.func_74762_e("BlockRotation");
        this.isRunning = compound.func_74764_b("isRunning") ? compound.func_74767_n("isRunning") : false;
        NBTTagList slaves = compound.func_150295_c("slaves", 11);
        for (int i = 0; i < slaves.func_74745_c(); ++i) {
            int[] pos = slaves.func_150306_c(i);
            this.slaves.add(new BlockPos(pos[0], pos[1], pos[2]));
        }
        this.init();
        this.tileParams = ModelHandler.getModelByID((int)this.type).tileParams;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BlockType", this.type);
        compound.func_74768_a("BlockRotation", this.rotation);
        compound.func_74757_a("isRunning", this.isRunning);
        NBTTagList slavesLst = new NBTTagList();
        for (BlockPos slave : this.slaves) {
            NBTTagIntArray pos = new NBTTagIntArray(new int[]{slave.func_177958_n(), slave.func_177956_o(), slave.func_177952_p()});
            slavesLst.func_74742_a((NBTBase)pos);
        }
        compound.func_74782_a("slaves", (NBTBase)slavesLst);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    private TileProps processTileData(NBTTagCompound compound) {
        TileProps tile = this;
        if (compound.func_74764_b("BlockType") && !ModelHandler.getModelByID((int)compound.func_74762_e((String)"BlockType")).tileType.getTileClass().equals(((Object)((Object)tile)).getClass())) {
            tile.func_145843_s();
            tile = (TileProps)((BlockProps)CameraObscura.blockProps).func_149915_a(this.field_145850_b, compound.func_74762_e("BlockType"));
            Chunk chunk = this.field_145850_b.func_175726_f(this.func_174877_v());
            if (chunk != null) {
                chunk.func_177426_a(this.func_174877_v(), (TileEntity)tile);
            }
            this.field_145850_b.func_175700_a((TileEntity)tile);
        }
        tile.func_145839_a(compound);
        return tile;
    }

    private void processClientTile(TileProps tile) {
        BlockPos blockPos = tile.func_174877_v();
        IBlockState blockState = tile.field_145850_b.func_180495_p(blockPos);
        tile.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 2);
        int lightValue = tile.getLightValue((IBlockAccess)tile.field_145850_b, blockPos);
        if (tile.field_145850_b != null && tile.oldLight != lightValue) {
            tile.field_145850_b.func_175664_x(blockPos);
            tile.oldLight = lightValue;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        TileProps tile = this.processTileData(pkt.func_148857_g());
        if (net.getDirection() == EnumPacketDirection.CLIENTBOUND) {
            this.processClientTile(tile);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.processClientTile(this.processTileData(tag));
    }

    public void renderParticles(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public int getMetadata() {
        return this.rotation;
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    public boolean isBed() {
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        if (this.getModelData() != null) {
            return this.getModelData().lightLevel;
        }
        return 0;
    }

    public int getSizeInventoryX() {
        return this.getModelData().invX;
    }

    public int getSizeInventoryY() {
        return this.getModelData().invY;
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        NBTTagCompound savedNBT = null;
        if (this.isTileSavedOnDrop()) {
            savedNBT = new NBTTagCompound();
            this.func_189515_b(savedNBT);
            savedNBT.func_82580_o("slaves");
        }
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack droppedItem = new ItemStack(ItemRegistry.itemProps, 1, this.type);
            if (savedNBT != null) {
                droppedItem.func_77983_a("savedProp", (NBTBase)savedNBT);
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)droppedItem);
        }
    }

    public boolean isTileSavedOnDrop() {
        return false;
    }

    public void addSlave(TileFake slave) {
        this.slaves.add(slave.func_174877_v());
    }

    public void rmSlave(TileFake slave) {
        this.slaves.remove(slave.func_174877_v());
        this.field_145850_b.func_175698_g(slave.func_174877_v());
    }

    public void removeSlaves() {
        for (BlockPos slave : this.slaves) {
            this.field_145850_b.func_175698_g(slave);
        }
    }

    public CSModelMetadata getModelData() {
        return ModelHandler.getModelByID(this.type);
    }

    public void markRenderDirty() {
    }

    public boolean sameID(TileEntity tile) {
        if (!(tile instanceof TileProps)) {
            return false;
        }
        return this.getModelData().decocraftModelID == ((TileProps)tile).getModelData().decocraftModelID;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Vector3[] bounds = ModelHandler.getModelByID((int)this.type).wrapper.getExtend(this.rotation);
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + bounds[0].x), (double)((float)pos.func_177956_o() + bounds[0].y), (double)((float)pos.func_177952_p() + bounds[0].z), (double)((float)pos.func_177958_n() + bounds[1].x), (double)((float)pos.func_177956_o() + bounds[1].y), (double)((float)pos.func_177952_p() + bounds[1].z));
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
    }

    public BlockPos getBedSpawnPosition(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return pos;
    }

    public int getRenderingType() {
        return this.type;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void blockPlaced(IBlockState state, World worldIn, BlockPos pos) {
    }

    public void randomTick(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void createSlaves() {
        CSModelMetadata data = ModelHandler.getModelByID(this.type);
        int[] extendBlock = data.wrapper.getExtendPlacementBlock(this.rotation);
        for (int lx = extendBlock[0]; lx <= extendBlock[3]; ++lx) {
            int ly;
            int n = ly = data.csmodel.getRootNode() != null && data.csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.IGNOREBELOWYPLANE) ? 0 : extendBlock[1];
            while (ly <= extendBlock[4]) {
                for (int lz = extendBlock[2]; lz <= extendBlock[5]; ++lz) {
                    TileFake targetFake;
                    TileProps targetMaster;
                    if (lx == 0 && ly == 0 && lz == 0) continue;
                    BlockPos trgBlockPos = new BlockPos(lx + this.field_174879_c.func_177958_n(), ly + this.field_174879_c.func_177956_o(), lz + this.field_174879_c.func_177952_p());
                    Block targetBlock = this.field_145850_b.func_180495_p(trgBlockPos).func_177230_c();
                    if (targetBlock == CameraObscura.blockFake && (targetMaster = (targetFake = (TileFake)this.field_145850_b.func_175625_s(trgBlockPos)).getMaster()) != null) {
                        targetMaster.rmSlave(targetFake);
                    }
                    if (targetBlock == CameraObscura.blockProps) continue;
                    this.field_145850_b.func_175656_a(trgBlockPos, CameraObscura.blockFake.func_176223_P().func_177226_a((IProperty)BlockFake.FACING, (Comparable)EnumFacing.NORTH));
                    TileFake fakeTile = (TileFake)this.field_145850_b.func_175625_s(trgBlockPos);
                    fakeTile.setMasterTile(this);
                    this.addSlave(fakeTile);
                    fakeTile.func_70296_d();
                }
                ++ly;
            }
        }
    }

    public static boolean canReplace(CraftStudioModelWrapper model, World world, int x, int y, int z, boolean isSneaking, int orient, int[] excludedArea) {
        int[] extendBlock = model.getExtendPlacementBlock(orient);
        for (int lx = extendBlock[0]; lx <= extendBlock[3]; ++lx) {
            int ly;
            int n = ly = model.getMetadata().csmodel.getRootNode() != null && model.getMetadata().csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.IGNOREBELOWYPLANE) ? 0 : extendBlock[1];
            while (ly <= extendBlock[4]) {
                for (int lz = extendBlock[2]; lz <= extendBlock[5]; ++lz) {
                    if (lx >= excludedArea[0] && lx <= excludedArea[3] && ly >= excludedArea[1] && ly <= excludedArea[4] && lz >= excludedArea[2] && lz <= excludedArea[5]) continue;
                    IBlockState blockState = world.func_180495_p(new BlockPos(lx + x, ly + y, lz + z));
                    Block targetBlock = blockState.func_177230_c();
                    if (blockState.func_185904_a() == Material.field_151579_a || targetBlock == Blocks.field_150329_H || targetBlock == Blocks.field_150431_aC || isSneaking && targetBlock == CameraObscura.blockFake || isSneaking && targetBlock == CameraObscura.blockProps) continue;
                    return false;
                }
                ++ly;
            }
        }
        return true;
    }

    public static boolean canPlace(CraftStudioModelWrapper model, World world, int x, int y, int z, boolean isSneaking, int orient) {
        int[] extendBlock = model.getExtendPlacementBlock(orient);
        for (int lx = extendBlock[0]; lx <= extendBlock[3]; ++lx) {
            int ly;
            int n = ly = model.getMetadata().csmodel.getRootNode() != null && model.getMetadata().csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.IGNOREBELOWYPLANE) ? 0 : extendBlock[1];
            while (ly <= extendBlock[4]) {
                for (int lz = extendBlock[2]; lz <= extendBlock[5]; ++lz) {
                    IBlockState blockState = world.func_180495_p(new BlockPos(lx + x, ly + y, lz + z));
                    Block targetBlock = blockState.func_177230_c();
                    if (blockState.func_185904_a() == Material.field_151579_a || targetBlock == Blocks.field_150329_H || targetBlock == Blocks.field_150431_aC || isSneaking && targetBlock == CameraObscura.blockFake || isSneaking && targetBlock == CameraObscura.blockProps) continue;
                    return false;
                }
                ++ly;
            }
        }
        return true;
    }

    public static TileProps checkAndGetTileEntity(World world, BlockPos finalPos, int type) {
        TileEntity tileentity = world.func_175625_s(finalPos);
        if (!(tileentity instanceof TileProps)) {
            throw new RuntimeException(String.format("Something went terribly wrong. Invalid TE detected after placement ! - %s", tileentity));
        }
        TileProps tileProps = (TileProps)((BlockProps)CameraObscura.blockProps).func_149915_a(world, type);
        if (!((Object)((Object)tileProps)).getClass().equals(tileentity.getClass())) {
            tileentity.func_145843_s();
            Chunk chunk = world.func_175726_f(finalPos);
            if (chunk != null) {
                chunk.func_177426_a(finalPos, (TileEntity)tileProps);
            }
            world.func_175700_a((TileEntity)tileProps);
        } else {
            tileProps = (TileProps)tileentity;
        }
        return tileProps;
    }
}

