/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.helpers;

import erogenousbeef.bigreactors.common.CircuitType;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;

public class RedNetChange {
    int channelID;
    CircuitType circuitType;
    boolean pulseOrToggle;
    BlockPos coord;

    public RedNetChange(int channelID, CircuitType circuitType, boolean pulseOrToggle, BlockPos coord) {
        this.channelID = channelID;
        this.circuitType = circuitType;
        this.pulseOrToggle = pulseOrToggle;
        this.coord = coord;
    }

    public static RedNetChange fromBytes(ByteBuf buf) {
        boolean coordNull;
        int channelID = buf.readInt();
        CircuitType type = CircuitType.TYPES[buf.readInt()];
        boolean pulseOrToggle = false;
        if (CircuitType.canBeToggledBetweenPulseAndNormal(type)) {
            pulseOrToggle = buf.readBoolean();
        }
        BlockPos coord = null;
        if (CircuitType.hasCoordinate(type) && !(coordNull = buf.readBoolean())) {
            coord = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
        return new RedNetChange(channelID, type, pulseOrToggle, coord);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.channelID);
        buf.writeInt(this.circuitType.ordinal());
        if (CircuitType.canBeToggledBetweenPulseAndNormal(this.circuitType)) {
            buf.writeBoolean(this.pulseOrToggle);
        }
        if (CircuitType.hasCoordinate(this.circuitType)) {
            buf.writeBoolean(this.coord == null);
            if (this.coord != null) {
                buf.writeInt(this.coord.func_177958_n());
                buf.writeInt(this.coord.func_177956_o());
                buf.writeInt(this.coord.func_177952_p());
            }
        }
    }

    public int getChannel() {
        return this.channelID;
    }

    public CircuitType getType() {
        return this.circuitType;
    }

    public BlockPos getCoord() {
        return this.coord;
    }

    public boolean getPulseOrToggle() {
        return this.pulseOrToggle;
    }
}

