/*
 * Decompiled with CFR 0.152.
 */
package com.msvdaamen.blocks;

import com.msvdaamen.Drawbridges;
import com.msvdaamen.blocks.BasicDrawbridge;
import com.msvdaamen.tileentities.DrawbridgeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Drawbridge
extends BasicDrawbridge
implements ITileEntityProvider {
    public final int range;
    public final int placementDuration;
    private boolean active;

    public Drawbridge(String name, int range, int placementDuration) {
        super(name);
        this.range = range;
        this.placementDuration = placementDuration;
    }

    @Override
    public void handleTick(World world, BlockPos pos, IBlockState state) {
        if (this.isTileEntity(world, pos)) {
            DrawbridgeTileEntity tile = (DrawbridgeTileEntity)world.func_175625_s(pos);
            if (!((Boolean)state.func_177229_b((IProperty)PULSE_MODE)).booleanValue()) {
                boolean isActive = this.isPowerd(world, pos);
                tile.setActive(isActive);
            }
            if (tile.isActive()) {
                this.placeBlocks(world, pos, tile);
            } else if (tile.getBlocksPlaced() > 0) {
                this.retractBlocks(world, pos, tile);
            }
        }
    }

    public void placeBlocks(World world, BlockPos pos, DrawbridgeTileEntity tile) {
        ItemStack mainSlot = tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT);
        if (!mainSlot.func_190926_b() && mainSlot.func_77973_b() instanceof ItemBlock) {
            BlockPos blockPos;
            Block blockAtPos;
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
            int offset = 0;
            for (int i = 0; i < tile.getRange(); ++i) {
                BlockPos blockPos2 = pos.func_177967_a(facing, i + 1);
                Block blockAtPos2 = world.func_180495_p(blockPos2).func_177230_c();
                ++offset;
                if (Block.func_149680_a((Block)blockAtPos2, (Block)Blocks.field_150350_a)) break;
            }
            if (Block.func_149680_a((Block)(blockAtPos = world.func_180495_p(blockPos = pos.func_177967_a(facing, offset)).func_177230_c()), (Block)Blocks.field_150350_a) && !mainSlot.func_190926_b()) {
                tile.setSavedStack(mainSlot.func_77946_l());
                world.func_175656_a(pos.func_177967_a(facing, offset), Block.func_149634_a((Item)mainSlot.func_77973_b()).func_176203_a(mainSlot.func_77960_j()));
                tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT).func_190918_g(1);
                tile.setBlocksPlaced(offset);
            }
        }
    }

    public void retractBlocks(World world, BlockPos pos, DrawbridgeTileEntity tile) {
        ItemStack mainSlot = tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT);
        if (mainSlot.func_190926_b() || ItemStack.func_179545_c((ItemStack)mainSlot, (ItemStack)tile.getSaveStack()) && tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT).func_190916_E() != tile.getItemStackHandler().getSlotLimit(tile.MAIN_SLOT)) {
            BlockPos blockPos;
            Block blockAtPos;
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
            int offset = 0;
            for (int i = 1; i <= tile.getBlocksPlaced() && (blockAtPos = world.func_180495_p(blockPos = pos.func_177967_a(facing, i)).func_177230_c()) == Block.func_149634_a((Item)tile.getSaveStack().func_77973_b()); ++i) {
                ++offset;
            }
            if (offset > 0) {
                if (tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT).func_190926_b()) {
                    tile.getItemStackHandler().setStackInSlot(tile.MAIN_SLOT, this.getItemstackWithMeta(world.func_180495_p(pos.func_177967_a(facing, offset))));
                } else {
                    tile.getItemStackHandler().getStackInSlot(tile.MAIN_SLOT).func_190917_f(1);
                }
                tile.setBlocksPlaced(offset - 1);
                world.func_175698_g(pos.func_177967_a(facing, offset));
            } else {
                tile.setBlocksPlaced(0);
            }
        }
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public int getPlacementDuration() {
        return this.placementDuration;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof DrawbridgeTileEntity)) {
            return false;
        }
        player.openGui((Object)Drawbridges.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        boolean powerd = this.isPowerd(world, observerPos);
        if (this.isTileEntity(world, observerPos)) {
            DrawbridgeTileEntity tile = (DrawbridgeTileEntity)world.func_175625_s(observerPos);
            if (((Boolean)observerState.func_177229_b((IProperty)PULSE_MODE)).booleanValue()) {
                if (powerd) {
                    if (tile.isActive() && !this.active) {
                        this.active = true;
                        tile.setActive(false);
                    } else if (!this.active) {
                        this.active = true;
                        tile.setActive(true);
                    }
                } else {
                    this.active = false;
                }
            } else {
                tile.setActive(powerd);
            }
        }
    }

    public boolean isPowerd(World world, BlockPos pos) {
        return world.func_175640_z(pos);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new DrawbridgeTileEntity(1, this.range);
    }

    public boolean isTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof DrawbridgeTileEntity;
    }
}

