/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DiagonalConnection;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.GridConnection;
import openblocks.client.renderer.tileentity.tank.HorizontalConnection;
import openblocks.client.renderer.tileentity.tank.ITankConnections;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.client.renderer.tileentity.tank.RenderConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.client.renderer.tileentity.tank.VerticalConnection;
import openblocks.common.tileentity.TileEntityTank;
import openmods.liquids.GenericTank;
import openmods.utils.Diagonal;

public class TankRenderLogic {
    private final GenericTank tank;
    private BlockPos pos;
    private World world;
    private TankConnections connections;
    private TankRenderFluidData renderData;

    public TankRenderLogic(GenericTank tank) {
        this.tank = tank;
    }

    private DoubledCoords createCoords(EnumFacing dir) {
        return new DoubledCoords(this.pos, dir);
    }

    private DoubledCoords createCoords(Diagonal dir) {
        return new DoubledCoords(this.pos, dir);
    }

    private ITankConnections getNeighbourTank(BlockPos pos) {
        TileEntity te = TankRenderUtils.getTileEntitySafe(this.world, pos);
        return te instanceof TileEntityTank ? ((TileEntityTank)te).getTankConnections() : null;
    }

    private ITankConnections getNeighbourTank(EnumFacing dir) {
        return this.getNeighbourTank(this.pos.func_177972_a(dir));
    }

    private ITankConnections getNeighbourTank(Diagonal dir) {
        return this.getNeighbourTank(this.pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
    }

    private DiagonalConnection selectDiagonalConnection(ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        Diagonal start = dir;
        dir = dir.rotateCW();
        if (tankCW != null) {
            return tankCW.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankD != null) {
            return tankD.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankCCW != null) {
            return tankCCW.getDiagonalConnection(dir);
        }
        return new DiagonalConnection(TankRenderUtils.calculatePhase(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), start), this.createCoords(start));
    }

    private void tryCornerConnection(Map<Diagonal, DiagonalConnection> diagonalConnections, ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        DiagonalConnection connection = this.selectDiagonalConnection(tankCW, tankD, tankCCW, dir);
        diagonalConnections.put(dir, connection);
    }

    private void tryHorizontalConnection(Map<EnumFacing, HorizontalConnection> horizontalConnections, ITankConnections neighbour, EnumFacing dir) {
        HorizontalConnection connection = neighbour != null ? neighbour.getHorizontalConnection(dir.func_176734_d()) : new HorizontalConnection(this.createCoords(dir));
        horizontalConnections.put(dir, connection);
    }

    private VerticalConnection tryBottomConnection(ITankConnections neighbour) {
        return neighbour != null ? neighbour.getTopConnection() : new VerticalConnection(this.createCoords(EnumFacing.DOWN));
    }

    private VerticalConnection tryTopConnection(ITankConnections neighbour) {
        return neighbour != null ? neighbour.getBottomConnection() : new VerticalConnection(this.createCoords(EnumFacing.UP));
    }

    private TankConnections updateConnections() {
        ITankConnections tankN = this.getNeighbourTank(EnumFacing.NORTH);
        ITankConnections tankS = this.getNeighbourTank(EnumFacing.SOUTH);
        ITankConnections tankW = this.getNeighbourTank(EnumFacing.WEST);
        ITankConnections tankE = this.getNeighbourTank(EnumFacing.EAST);
        ITankConnections tankNE = this.getNeighbourTank(Diagonal.NE);
        ITankConnections tankNW = this.getNeighbourTank(Diagonal.NW);
        ITankConnections tankSE = this.getNeighbourTank(Diagonal.SE);
        ITankConnections tankSW = this.getNeighbourTank(Diagonal.SW);
        ITankConnections tankT = this.getNeighbourTank(EnumFacing.UP);
        ITankConnections tankB = this.getNeighbourTank(EnumFacing.DOWN);
        VerticalConnection topConnection = this.tryTopConnection(tankT);
        VerticalConnection bottomConnection = this.tryBottomConnection(tankB);
        EnumMap diagonalConnections = Maps.newEnumMap(Diagonal.class);
        EnumMap horizontalConnections = Maps.newEnumMap(EnumFacing.class);
        this.tryHorizontalConnection(horizontalConnections, tankN, EnumFacing.NORTH);
        this.tryHorizontalConnection(horizontalConnections, tankS, EnumFacing.SOUTH);
        this.tryHorizontalConnection(horizontalConnections, tankW, EnumFacing.WEST);
        this.tryHorizontalConnection(horizontalConnections, tankE, EnumFacing.EAST);
        this.tryCornerConnection(diagonalConnections, tankN, tankNW, tankW, Diagonal.NW);
        this.tryCornerConnection(diagonalConnections, tankW, tankSW, tankS, Diagonal.SW);
        this.tryCornerConnection(diagonalConnections, tankE, tankNE, tankN, Diagonal.NE);
        this.tryCornerConnection(diagonalConnections, tankS, tankSE, tankE, Diagonal.SE);
        return new TankConnections(this.tank, diagonalConnections, horizontalConnections, topConnection, bottomConnection);
    }

    public void initialize(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        if (this.connections != null) {
            this.connections.detach();
        }
        if (world == null) {
            this.connections = null;
            this.renderData = null;
        } else {
            float phase = TankRenderUtils.calculatePhase(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.connections = this.updateConnections();
            this.renderData = new TankRenderFluidData(this.connections, this.tank, phase);
        }
    }

    public void validateConnections(World world, BlockPos pos) {
        if (world != this.world || this.connections == null || !this.connections.checkConsistency(pos)) {
            this.initialize(world, pos);
        }
    }

    public void invalidateConnections() {
        if (this.connections != null) {
            this.connections.detach();
        }
        this.connections = null;
        this.renderData = null;
    }

    public void updateFluid(FluidStack stack) {
        if (this.connections != null) {
            this.connections.updateFluid(stack);
        }
    }

    public ITankRenderFluidData getTankRenderData() {
        return this.renderData;
    }

    public ITankConnections getTankConnections() {
        return this.connections;
    }

    private static class TankRenderFluidData
    implements ITankRenderFluidData {
        private final TankConnections connections;
        private final GenericTank tank;
        private final float phase;

        public TankRenderFluidData(TankConnections connections, GenericTank tank, float phase) {
            this.connections = connections;
            this.tank = tank;
            this.phase = phase;
        }

        private static boolean isConnected(GridConnection connection) {
            return connection != null ? connection.isConnected() : false;
        }

        @Override
        public boolean shouldRenderFluidWall(EnumFacing side) {
            switch (side) {
                case DOWN: {
                    return !TankRenderFluidData.isConnected(this.connections.getBottomConnection());
                }
                case UP: {
                    return !TankRenderFluidData.isConnected(this.connections.getTopConnection());
                }
                case EAST: 
                case WEST: 
                case NORTH: 
                case SOUTH: {
                    return !TankRenderFluidData.isConnected(this.connections.getHorizontalConnection(side));
                }
            }
            return true;
        }

        @Override
        public boolean hasFluid() {
            return this.tank.getFluidAmount() > 0;
        }

        @Override
        public FluidStack getFluid() {
            return this.tank.getFluid();
        }

        @Override
        public float getCenterFluidLevel(float time) {
            float raw = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            return TankRenderUtils.calculateRenderHeight(time, this.phase, raw);
        }

        @Override
        public float getCornerFluidLevel(Diagonal corner, float time) {
            DiagonalConnection diagonal = this.connections.getDiagonalConnection(corner);
            return diagonal != null ? diagonal.getRenderHeight(corner.getOpposite(), time) : this.getCenterFluidLevel(time);
        }
    }

    private static class TankConnections
    implements ITankConnections {
        private final GenericTank tank;
        private final Map<Diagonal, DiagonalConnection> diagonalConnections;
        private final Map<EnumFacing, HorizontalConnection> horizontalConnections;
        private final VerticalConnection topConnection;
        private final VerticalConnection bottomConnection;

        public TankConnections(GenericTank tank, Map<Diagonal, DiagonalConnection> diagonalConnections, Map<EnumFacing, HorizontalConnection> horizontalConnections, VerticalConnection topConnection, VerticalConnection bottomConnection) {
            this.tank = tank;
            this.diagonalConnections = diagonalConnections;
            this.horizontalConnections = horizontalConnections;
            this.topConnection = topConnection;
            this.bottomConnection = bottomConnection;
        }

        @Override
        public VerticalConnection getTopConnection() {
            return this.topConnection;
        }

        @Override
        public VerticalConnection getBottomConnection() {
            return this.bottomConnection;
        }

        @Override
        public HorizontalConnection getHorizontalConnection(EnumFacing dir) {
            return this.horizontalConnections.get(dir);
        }

        @Override
        public DiagonalConnection getDiagonalConnection(Diagonal dir) {
            return this.diagonalConnections.get(dir);
        }

        public void updateFluid(FluidStack fluidStack) {
            for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
                entry.getValue().updateFluid(entry.getKey().getOpposite(), fluidStack);
            }
            for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
                ((HorizontalConnection)entry.getValue()).updateFluid(((EnumFacing)entry.getKey()).func_176734_d(), fluidStack);
            }
            this.topConnection.updateBottomFluid(fluidStack, this.tank.getSpace() == 0);
            this.bottomConnection.updateTopFluid(fluidStack);
        }

        private static boolean checkConsistency(RenderConnection connection, BlockPos pos, EnumFacing dir) {
            return connection != null && connection.isPositionEqualTo(pos, dir);
        }

        private static boolean checkConsistency(RenderConnection connection, BlockPos pos, Diagonal dir) {
            return connection != null && connection.isPositionEqualTo(pos, dir);
        }

        private boolean checkHorizontalConsistency(BlockPos pos, EnumFacing dir) {
            return TankConnections.checkConsistency((RenderConnection)this.horizontalConnections.get(dir), pos, dir);
        }

        private boolean checkDiagonalConsistency(BlockPos pos, Diagonal dir) {
            return TankConnections.checkConsistency((RenderConnection)this.diagonalConnections.get(dir), pos, dir);
        }

        public boolean checkConsistency(BlockPos pos) {
            return TankConnections.checkConsistency((RenderConnection)this.topConnection, pos, EnumFacing.UP) && TankConnections.checkConsistency((RenderConnection)this.bottomConnection, pos, EnumFacing.DOWN) && this.checkHorizontalConsistency(pos, EnumFacing.NORTH) && this.checkHorizontalConsistency(pos, EnumFacing.SOUTH) && this.checkHorizontalConsistency(pos, EnumFacing.EAST) && this.checkHorizontalConsistency(pos, EnumFacing.WEST) && this.checkDiagonalConsistency(pos, Diagonal.NE) && this.checkDiagonalConsistency(pos, Diagonal.NW) && this.checkDiagonalConsistency(pos, Diagonal.SE) && this.checkDiagonalConsistency(pos, Diagonal.SW);
        }

        public void detach() {
            for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
                entry.getValue().clearFluid(entry.getKey().getOpposite());
            }
            for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
                ((HorizontalConnection)entry.getValue()).clearFluid(((EnumFacing)entry.getKey()).func_176734_d());
            }
            if (this.topConnection != null) {
                this.topConnection.clearBottomFluid();
            }
            if (this.bottomConnection != null) {
                this.bottomConnection.clearTopFluid();
            }
        }
    }
}

